/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.uml;

import ch.e2e.builder.analyzer.gui.uml.ActivationBox;
import ch.e2e.builder.analyzer.gui.uml.BackendCall;
import ch.e2e.builder.analyzer.gui.uml.CustomBox;
import ch.e2e.builder.analyzer.gui.uml.DoAction;
import ch.e2e.builder.analyzer.gui.uml.Lifeline;
import ch.e2e.builder.analyzer.gui.uml.MessageToSelf;
import ch.e2e.builder.analyzer.gui.uml.ObjectWithToolTip;
import ch.e2e.builder.analyzer.gui.uml.PStateCall;
import ch.e2e.builder.analyzer.gui.uml.ServiceCall;
import ch.e2e.builder.analyzer.gui.uml.Signal;
import ch.e2e.builder.analyzer.gui.uml.Transition;
import ch.e2e.builder.analyzer.model.TransactionLogEntry;
import ch.e2e.builder.analyzer.model.TransactionLogRequest;
import ch.e2e.builder.analyzer.model.TransactionLogTransaction;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.util.CalendarUtilities;
import com.mxgraph.io.mxCodec;
import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TransactionLogSequenceGraphBuilder {
    public static final double DY = 30.0;
    private E2EBuilderModule module;
    private Iterator<TransactionLogEntry> entries;
    private LinkedHashMap<String, Lifeline> lifelines = new LinkedHashMap();
    private mxGraph graph;
    private static final double WIDTH = 765.0;
    private static final double HEIGHT = 75.0;
    private static final double TITLE_X = 10.0;
    private static final double TITLE_Y = 5.0;
    private static final double TITLE_WIDTH = 745.0;
    private static final double TITLE_HEIGHT = 23.0;
    private static final double INFO_X = 10.0;
    private static final double INFO_Y = 34.0;
    private static final double INFO_WIDTH = 745.0;
    private static final double INFO_HEIGHT = 36.0;
    private static final double INFO_I_X = 719.0;
    private static final double INFO_I_Y = 34.0;

    public TransactionLogSequenceGraphBuilder(TransactionLogTransaction transaction, E2EBuilderModule module) {
        this.module = module;
        this.initialiseGraph();
        this.graph.getModel().beginUpdate();
        try {
            this.buildTitle(transaction);
            this.buildGraph(transaction);
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    private TransactionLogEntry getNextEntry() {
        return this.entries != null && this.entries.hasNext() ? this.entries.next() : null;
    }

    private Lifeline getLifeline(String key, String name, Lifeline.Type type) {
        Lifeline lifeline = this.lifelines.get(key);
        if (lifeline == null) {
            lifeline = new Lifeline(key, name, type);
            this.lifelines.put(key, lifeline);
        }
        return lifeline;
    }

    private void buildGraph(TransactionLogTransaction transaction) {
        this.lifelines.put("actor", new Lifeline("actor", "actor", Lifeline.Type.ACTOR, "noLabel=true;image;image=/ch/e2e/builder/analyzer/images/actor.icon.png"));
        for (TransactionLogRequest request : transaction.getRequests()) {
            this.entries = request.getEntries().iterator();
            this.process(null);
        }
        ArrayList<Lifeline> list = new ArrayList<Lifeline>(this.lifelines.values());
        Collections.sort(list);
        double x = 15.0;
        for (Lifeline lifeline : list) {
            mxCell cell = lifeline.createCell(this.graph, transaction.getNumberOfLines());
            this.graph.updateGroupBounds(new Object[]{cell});
            this.graph.translateCell((Object)cell, x, 100.0);
            x += cell.getGeometry().getWidth() + 20.0;
        }
        for (Lifeline lifeline : list) {
            lifeline.createEdges(this.graph);
        }
    }

    private void buildTitle(TransactionLogTransaction transaction) {
        Object parent = this.graph.insertVertex(null, null, null, 5.0, 5.0, 765.0, 75.0, "header");
        String label = "Transaction Id: " + transaction.getName();
        Object cell = this.graph.insertVertex(parent, null, (Object)label, 10.0, 5.0, 745.0, 23.0, "header1");
        this.graph.getCellGeometry(cell).setOffset(new mxPoint(7.0, -3.0));
        label = "<html><table frame='void' cellpadding='1'><tr><td><b>Start:</b></td><td>" + CalendarUtilities.toISO8601((Date)transaction.getStart()) + "</td></tr><tr><td><b>End:</b></td><td>" + CalendarUtilities.toISO8601((Date)transaction.getEnd()) + "</td></tr></table></html>";
        cell = this.graph.insertVertex(parent, null, (Object)label, 10.0, 34.0, 745.0, 36.0, "header2");
        this.graph.getCellGeometry(cell).setOffset(new mxPoint(7.0, -3.0));
        this.graph.insertVertex(parent, null, (Object)"i", 719.0, 34.0, 36.0, 36.0, "header3");
    }

    private void process(ActivationBox parent) {
        TransactionLogEntry entry = this.getNextEntry();
        if (entry == null) {
            return;
        }
        if (entry.isServiceEnter()) {
            ServiceCall serviceCall = new ServiceCall(entry);
            Lifeline lifeline = this.getLifeline(serviceCall.getLifelineKey(), serviceCall.getLifelineName(), Lifeline.Type.SERVICE);
            lifeline.addActivationBox(serviceCall);
            this.process(serviceCall);
        } else if (entry.isServiceExit()) {
            ServiceCall serviceCall = (ServiceCall)parent;
            if (serviceCall != null) {
                serviceCall.setReturnMessage(entry);
            }
            this.process(null);
        } else if (entry.isIOEnter()) {
            if (entry.isPState()) {
                if ("Create".equals(entry.getParam_1())) {
                    PStateCall pStateCall = new PStateCall(entry);
                    if (parent != null) {
                        parent.add(pStateCall);
                    }
                    this.process(pStateCall);
                } else if ("Send".equals(entry.getParam_1())) {
                    Signal signal = new Signal(entry);
                    if (parent != null) {
                        parent.add(signal);
                    }
                    this.process(signal);
                }
            } else {
                BackendCall backendCall = new BackendCall(entry);
                if (parent != null) {
                    parent.add(backendCall);
                }
                Lifeline lifeline = this.getLifeline(backendCall.getLifelineKey(), backendCall.getLifelineName(), Lifeline.Type.BACKEND);
                lifeline.addActivationBox(backendCall);
                this.process(backendCall);
            }
        } else if (entry.isIOExit()) {
            if (entry.isPState()) {
                if ("Create".equals(entry.getParam_1())) {
                    PStateCall pStateCall = (PStateCall)parent;
                    pStateCall.setReturnMessage(entry);
                    Lifeline lifeline = this.getLifeline(pStateCall.getLifelineKey(), pStateCall.getLifelineName(), Lifeline.Type.PSTATE);
                    lifeline.addActivationBox(pStateCall);
                    this.process(pStateCall.getParent());
                } else if ("Send".equals(entry.getParam_1())) {
                    Signal signal = (Signal)parent;
                    signal.setReturnMessage(entry);
                    Lifeline lifeline = this.getLifeline(signal.getLifelineKey(), signal.getLifelineName(), Lifeline.Type.PSTATE);
                    lifeline.addActivationBox(signal);
                    this.process(signal.getParent());
                }
            } else {
                BackendCall backendCall = (BackendCall)parent;
                backendCall.setReturnMessage(entry);
                this.process(backendCall.getParent());
            }
        } else if (entry.isTransitionEnter()) {
            Transition transition = new Transition(entry);
            if (parent == null) {
                Lifeline lifeline = this.getLifeline(transition.getLifelineKey(), transition.getLifelineName(), Lifeline.Type.PSTATE);
                parent = new PStateCall(entry);
                lifeline.addActivationBox(parent);
            }
            parent.add(transition);
            this.process(transition);
        } else if (entry.isTransitionExit()) {
            Transition transition = (Transition)parent;
            transition.setReturnMessage(entry);
            if (transition.getParent() instanceof PStateCall) {
                transition.getParent().setReturnMessage(entry);
            }
            this.process(transition.getParent());
        } else if (entry.isDoActionEnter()) {
            DoAction doAction = new DoAction(entry);
            if (parent == null) {
                Lifeline lifeline = this.getLifeline(doAction.getLifelineKey(), doAction.getLifelineName(), Lifeline.Type.PSTATE);
                parent = new PStateCall(entry);
                lifeline.addActivationBox(parent);
            }
            parent.add(doAction);
            this.process(doAction);
        } else if (entry.isDoActionExit()) {
            DoAction doAction = (DoAction)parent;
            doAction.setReturnMessage(entry);
            if (doAction.getParent() instanceof PStateCall) {
                doAction.getParent().setReturnMessage(entry);
            }
            this.process(doAction.getParent());
        } else if (entry.isCustom()) {
            CustomBox customBox = new CustomBox(entry);
            ActivationBox p = parent;
            while (p instanceof MessageToSelf) {
                p = p.getParent();
            }
            if (p == null) {
                Lifeline lifeline = this.lifelines.get("actor");
                lifeline.addActivationBox(customBox);
            } else {
                p.add(customBox);
            }
            this.process(parent);
        } else {
            System.out.println("Warning: don't know how to process line " + entry.getLineNumber() + ".");
            this.process(parent);
        }
    }

    private void initialiseGraph() {
        this.graph = new mxGraph(){

            public boolean isCellFoldable(Object cell, boolean collapse) {
                return false;
            }

            public String getToolTipForCell(Object cell) {
                String toolTip = null;
                Object userObject = this.getModel().getValue(cell);
                if (userObject instanceof ObjectWithToolTip) {
                    toolTip = ((ObjectWithToolTip)userObject).getToolTipText();
                }
                return toolTip;
            }

            public boolean isCellLocked(Object cell) {
                return super.isCellLocked(cell) || !"group".equals(this.getModel().getStyle(cell));
            }
        };
        this.graph.setAllowDanglingEdges(false);
        this.graph.setExtendParentsOnAdd(true);
        this.graph.setExtendParents(true);
        this.graph.setConstrainChildren(true);
        this.graph.setDisconnectOnMove(false);
        this.graph.setCellsResizable(false);
        this.graph.setCellsEditable(false);
        this.graph.setCellsBendable(false);
        this.graph.setCellsCloneable(false);
        this.graph.setCellsDeletable(false);
        this.graph.setLabelsClipped(false);
        this.graph.setHtmlLabels(true);
        this.graph.setKeepEdgesInBackground(true);
        this.graph.setDropEnabled(false);
        this.graph.setCellsDisconnectable(false);
        this.loadStylesheet();
    }

    private void loadStylesheet() {
        mxCodec codec = new mxCodec();
        Document doc = mxUtils.loadDocument((String)this.getClass().getResource("/ch/e2e/builder/analyzer/properties/basic-diagram-style.xml").toString());
        codec.decode((Node)doc.getDocumentElement(), (Object)this.graph.getStylesheet());
    }
}

