/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project;

import ch.e2e.builder.base.project.ProjectInstantiationException;
import ch.e2e.builder.base.project.ProjectSettingObjectMap;
import ch.e2e.builder.base.project.ProjectSettingObjectWSChecker;
import ch.e2e.builder.base.project.ValueFactory;
import ch.e2e.builder.base.project.ValueInstantiationException;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectReader {
    private static ProjectReader reader;
    private File projectFile;

    private ProjectReader() {
    }

    public static HashMap<String, ProjectSettingObjectMap> readSettings(HashMap<String, ProjectSettingObjectWSChecker> settingWSCheckers, File projectFile, File projectWorkspaceFile, boolean exportSystemValues) throws ProjectInstantiationException {
        if (reader == null) {
            reader = new ProjectReader();
        }
        ProjectReader.reader.projectFile = projectFile;
        return reader.readAllSettings(settingWSCheckers, projectFile, projectWorkspaceFile, exportSystemValues);
    }

    public static File getProjectFile() {
        if (reader == null) {
            throw new RuntimeException("ProjectReader is not initialized.");
        }
        return ProjectReader.reader.projectFile;
    }

    public static void setProjectFile(File projectFile) {
        if (reader == null) {
            reader = new ProjectReader();
        } else {
            ProjectReader.reader.projectFile = projectFile;
        }
    }

    public HashMap<String, ProjectSettingObjectMap> readAllSettings(HashMap<String, ProjectSettingObjectWSChecker> settingWSCheckers, File projectFile, File projectWorkspaceFile, boolean exportSystemValues) throws ProjectInstantiationException {
        try {
            HashMap<String, ProjectSettingObjectMap> settings = new HashMap<String, ProjectSettingObjectMap>();
            Document projectDoc = DomUtilities.parse((File)projectFile, (boolean)false, (boolean)false);
            this.readSettings(settingWSCheckers, settings, projectDoc, projectFile.getParentFile(), exportSystemValues, false);
            if (projectWorkspaceFile.exists()) {
                Document projectWorkspaceDoc = DomUtilities.parse((File)projectWorkspaceFile, (boolean)false, (boolean)false);
                this.readSettings(settingWSCheckers, settings, projectWorkspaceDoc, projectFile.getParentFile(), exportSystemValues, true);
            }
            return settings;
        }
        catch (Exception ex) {
            throw new ProjectInstantiationException("Could not parse " + projectFile.getAbsolutePath(), ex);
        }
    }

    private void readSettings(HashMap<String, ProjectSettingObjectWSChecker> settingWSCheckers, HashMap<String, ProjectSettingObjectMap> settings, Document projectDoc, File projectHome, boolean exportSystemValues, boolean workspaceSetting) throws ProjectInstantiationException {
        Element projectElement = projectDoc.getDocumentElement();
        if (projectElement.getNodeName().equals("project")) {
            NodeList modules = projectElement.getChildNodes();
            try {
                this.readModuleSettings(settingWSCheckers, settings, modules, projectHome, exportSystemValues, workspaceSetting);
            }
            catch (ValueInstantiationException e) {
                throw new ProjectInstantiationException(e.getMessage(), e.getTargetException());
            }
        } else {
            throw new ProjectInstantiationException("Not a valid E2EBuilder project.");
        }
    }

    private void readModuleSettings(HashMap<String, ProjectSettingObjectWSChecker> settingWSCheckers, HashMap<String, ProjectSettingObjectMap> settings, NodeList modules, File projectHome, boolean exportSystemValues, boolean workspaceSetting) throws ValueInstantiationException {
        if (modules != null) {
            Node child;
            int i;
            int length = modules.getLength();
            for (i = 0; i < length; ++i) {
                child = modules.item(i);
                if (child.getNodeType() != 1) continue;
                this.readGenericSettings((Element)modules.item(i), settingWSCheckers, settings, projectHome, exportSystemValues, workspaceSetting);
                ++i;
                break;
            }
            while (i < length) {
                child = modules.item(i);
                if (!child.getNodeName().equals("generic") && child.getNodeType() == 1) {
                    this.readModuleSettings((Element)child, settingWSCheckers, settings, projectHome, exportSystemValues, workspaceSetting);
                }
                ++i;
            }
        }
    }

    private void readGenericSettings(Element module, HashMap<String, ProjectSettingObjectWSChecker> settingWSCheckers, HashMap<String, ProjectSettingObjectMap> settings, File projectHome, boolean exportSystemValues, boolean workspaceSetting) throws ValueInstantiationException {
        String moduleName = module.getNodeName();
        ProjectSettingObjectMap moduleSettings = settings.get(moduleName);
        if (moduleSettings == null) {
            moduleSettings = new ProjectSettingObjectMap();
            settings.put(moduleName, moduleSettings);
        }
        moduleSettings.put("home", projectHome);
        NodeList entries = module.getChildNodes();
        if (entries != null) {
            int length = entries.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = entries.item(i);
                if (child.getNodeName().equals("home") || child.getNodeType() != 1) continue;
                this.readEntry((Element)child, settingWSCheckers, moduleSettings, projectHome, "ch.e2e.builder.base.", exportSystemValues, module, workspaceSetting);
            }
        }
        moduleSettings.put("name", projectHome.getName());
        settings.put(module.getNodeName(), moduleSettings);
    }

    private void readModuleSettings(Element module, HashMap<String, ProjectSettingObjectWSChecker> settingWSCheckers, HashMap<String, ProjectSettingObjectMap> settings, File projectHome, boolean exportSystemValues, boolean workspaceSetting) throws ValueInstantiationException {
        String moduleName = module.getNodeName();
        ProjectSettingObjectMap moduleSettings = settings.get(moduleName);
        if (moduleSettings == null) {
            moduleSettings = new ProjectSettingObjectMap();
            settings.put(moduleName, moduleSettings);
        }
        String prefix = ProjectSettingObjectMap.getModulePrefix(moduleName);
        NodeList entries = module.getChildNodes();
        if (entries != null) {
            int length = entries.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = entries.item(i);
                if (child.getNodeType() != 1) continue;
                this.readEntry((Element)child, settingWSCheckers, moduleSettings, projectHome, prefix, exportSystemValues, module, workspaceSetting);
            }
        }
        settings.put(module.getNodeName(), moduleSettings);
    }

    private void readEntry(Element entry, HashMap<String, ProjectSettingObjectWSChecker> settingWSCheckers, ProjectSettingObjectMap moduleSettings, File projectHome, String prefix, boolean exportSystemValue, Element module, boolean workspaceSetting) throws ValueInstantiationException {
        String name = entry.getNodeName();
        Object value = ValueFactory.createValue(entry, projectHome);
        if (value != null) {
            ProjectSettingObjectWSChecker checker = settingWSCheckers.get(module.getNodeName());
            checker = checker != null ? checker : new ProjectSettingObjectWSChecker();
            boolean workspace = checker.isWorkspace(name, workspaceSetting);
            moduleSettings.put(name, value, workspace);
            if (exportSystemValue) {
                System.setProperty(prefix + name, value.toString());
            }
        }
    }
}

