/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.error;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderErrorHandler;
import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.base.error.Logging;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.lang.reflect.Constructor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ErrorLogService {
    public static void readErrorsAndWarnings(AbstractErrorHandler errorHandler) {
        File logfile = errorHandler.getLogfile();
        ErrorLogService.readErrorsAndWarnings(errorHandler, logfile);
    }

    private static void readErrorsAndWarnings(AbstractErrorHandler errorHandler, File logfile) {
        if (logfile.exists() && logfile.length() > 0L) {
            try {
                Document errorDoc = DomUtilities.parse((File)logfile, (boolean)false, (boolean)false);
                NodeList errorList = errorDoc.getDocumentElement().getElementsByTagName("Error");
                if (errorList != null) {
                    int length = errorList.getLength();
                    for (int i = 0; i < length; ++i) {
                        Element errorElement = (Element)errorList.item(i);
                        String type = errorElement.getAttribute("type");
                        ErrorLogService.addError(type, errorHandler, errorElement);
                    }
                }
                errorHandler.readLogfileExtensions(errorDoc);
            }
            catch (Exception ex) {
                Logging.logger.severe("Caught a " + ex.getClass().getName() + ": " + ex.getMessage());
                Logging.logger.throwing(ErrorLogService.class.getName(), "readErrorsAndWarnings", ex);
                logfile.delete();
                errorHandler.clear();
            }
        }
    }

    private static void addError(String type, BuilderErrorHandler errorHandler, Element errorElement) {
        try {
            Class<?> errorClazz = Class.forName(type);
            Constructor<?> constructor = errorClazz.getConstructor(Element.class);
            AbstractBuilderError error = (AbstractBuilderError)constructor.newInstance(errorElement);
            if (error instanceof BuilderWarning) {
                errorHandler.warning((BuilderWarning)((Object)error));
            } else if (error instanceof BuilderFatalError) {
                errorHandler.fatalError((BuilderFatalError)((Object)error));
            } else {
                errorHandler.error(error);
            }
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(ErrorLogService.class.getName(), "addError", e);
        }
    }
}

