/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.regtest.event.LibraryChangedEvent;
import ch.e2e.builder.regtest.event.LibraryObserver;
import ch.e2e.builder.regtest.model.TreePathElement;
import ch.e2e.builder.regtest.testsuite.ImportTestcaseContainer;
import ch.e2e.builder.regtest.testsuite.Library;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.test.E2ETestSuite;
import ch.e2e.test.E2ETestSuiteTemplate;
import ch.e2e.test.Testable;
import java.io.File;
import org.w3c.dom.Document;

public class LibraryChildSuite
extends Library {
    private final Library parent;

    public LibraryChildSuite(Document document, File testSuiteFile, Library parent, TreeTestSuite parentSuite) throws Exception {
        super(document, testSuiteFile, parentSuite, true);
        this.parent = parent == null ? this.findParentLibrary() : parent;
        this.getProperties().put("library.output.folder", this.createLibraryOutputPath());
    }

    LibraryChildSuite(String name, Library parent) {
        this(name, parent, parent);
    }

    LibraryChildSuite(String name, Library parent, Library parentLibrary) {
        super(name, false);
        this.parent = parentLibrary == null ? this.findParentLibrary() : parentLibrary;
        this.setParent(parent);
        this.setInLibrary(true);
    }

    LibraryChildSuite(ImportTestcaseContainer testcaseContainer, File testSuiteFile, Library parent, TreeTestSuite parentSuite) throws Exception {
        super(testcaseContainer, testSuiteFile, parentSuite);
        this.parent = parent == null ? this.findParentLibrary() : parent;
        this.setInLibrary(true);
    }

    LibraryChildSuite(E2ETestSuiteTemplate template, Library parent, TreeTestSuite parentSuite) throws Exception {
        super(template, (E2ETestSuite)parentSuite, true);
        this.parent = parent == null ? this.findParentLibrary() : parent;
    }

    @Override
    public Library getLibrary() {
        Object parent = this.getTreeParent();
        while (parent instanceof TreePathElement) {
            if (!(parent instanceof LibraryChildSuite) && parent instanceof Library) {
                return (Library)parent;
            }
            parent = ((TreePathElement)parent).getTreeParent();
        }
        return null;
    }

    @Override
    public LibraryChildSuite createChildSuite(String name) {
        return new LibraryChildSuite(name, (Library)this, this.parent);
    }

    @Override
    public LibraryChildSuite createTestSuite(E2ETestSuiteTemplate template, boolean inLibrary) throws Exception {
        return new LibraryChildSuite(template, this.parent, (TreeTestSuite)this);
    }

    @Override
    protected LibraryChildSuite createTestSuite(ImportTestcaseContainer testcaseContainer, File testSuiteFile) throws Exception {
        return new LibraryChildSuite(testcaseContainer, testSuiteFile, this.parent, (TreeTestSuite)this);
    }

    @Override
    protected void fireLibraryChanged(TreeTestSuite changedTestSuite) {
        Library parent = this.findParentLibrary();
        if (parent != null) {
            parent.fireLibraryChanged(changedTestSuite);
        }
    }

    private Library findParentLibrary() {
        Library parent = this.parent;
        Testable parentSuite = this.getParent();
        while (parent == null && parentSuite != null) {
            if (parentSuite instanceof LibraryChildSuite && ((LibraryChildSuite)parentSuite).getLibrary() != null) {
                parent = ((LibraryChildSuite)parentSuite).getLibrary();
                continue;
            }
            if (!(parentSuite instanceof LibraryChildSuite) && parentSuite instanceof Library) {
                parent = (Library)parentSuite;
                continue;
            }
            parentSuite = parentSuite.getParent();
        }
        return parent;
    }

    @Override
    public void fireRenameEvent(LibraryChangedEvent renameEvent) {
        Library library = this.findParentLibrary();
        LibraryChangedEvent event = new LibraryChangedEvent(this, library);
        String path = this.getPath().replace("libraries/", "");
        int index = path.lastIndexOf(47);
        if (index != -1) {
            path = path.substring(0, index + 1) + renameEvent.getOldId();
        }
        event.setTestPath(path);
        super.fireRenameEvent(event);
    }

    @Override
    protected void fireTestRemovedEvent(LibraryChangedEvent event) {
        Library parent = this.findParentLibrary();
        if (parent != null) {
            event.setLibrary(parent);
        }
        LibraryObserver.getInstance().testRemoved(event);
    }

    @Override
    public TreeTestSuite createNewTestSuite(String name) {
        return new LibraryChildSuite(name, this.parent);
    }

    @Override
    public boolean isLibrary() {
        return false;
    }

    @Override
    public boolean isInLibrary() {
        return true;
    }
}

