/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.model;

import ch.e2e.builder.base.gui.ResourceEditor;
import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.event.EditTestPreferencesEvent;
import ch.e2e.builder.regtest.event.LibraryObserver;
import ch.e2e.builder.regtest.event.TestSuiteTreeChangedEvent;
import ch.e2e.builder.regtest.gui.OptionsDialog;
import ch.e2e.builder.regtest.model.LibrariesRootPopupMenu;
import ch.e2e.builder.regtest.model.LogfilePopupMenu;
import ch.e2e.builder.regtest.model.OptionsPopupMenu;
import ch.e2e.builder.regtest.model.RunPopupMenu;
import ch.e2e.builder.regtest.model.RunPreferencesPopupMenu;
import ch.e2e.builder.regtest.model.RunRemovePopupMenu;
import ch.e2e.builder.regtest.model.TestPopupMenu;
import ch.e2e.builder.regtest.model.TestSelection;
import ch.e2e.builder.regtest.model.TestSuiteOptionsPopupMenu;
import ch.e2e.builder.regtest.model.TestSuitePopupMenu;
import ch.e2e.builder.regtest.model.TestSuiteRootPopupMenu;
import ch.e2e.builder.regtest.model.TestSuiteTreeModel;
import ch.e2e.builder.regtest.model.TreePathElement;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.TestSuiteOptions;
import ch.e2e.builder.regtest.testsuite.TestSuiteRoot;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.event.EventController;
import ch.e2e.swing.Tree;
import ch.e2e.test.E2ETestSuiteTemplate;
import ch.e2e.test.E2ETestSuiteTemplateFactory;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.PropertiesHelper;
import ch.e2e.test.TestLogfile;
import ch.e2e.test.TestProperties;
import ch.e2e.test.TestSelectedEvent;
import ch.e2e.test.Testable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;

public class TestSuiteRootTreeModel
extends TestSuiteTreeModel {
    private TestSuiteRootPopupMenu rootPopupMenu;
    private TestSuitePopupMenu testSuitePopupMenu;
    private TestPopupMenu testPopupMenu;
    private LogfilePopupMenu logfilePopupMenu;
    private TestSuiteOptionsPopupMenu testSuiteOptionsPopupMenu;
    private OptionsPopupMenu optionsPopupMenu;
    private RunPopupMenu runPopupMenu;
    private RunRemovePopupMenu runRemovePopupMenu;
    private RunPreferencesPopupMenu runPreferencesPopupMenu;
    private LibrariesRootPopupMenu librariesRootPopupMenu;
    private File root;
    private TestSuiteRoot testSuiteRoot;
    private LibrariesRoot libraries = new LibrariesRoot();

    public TestSuiteRootTreeModel(E2EBuilderModule module) {
        super(module);
    }

    @Override
    public void setRoot(File root) {
        if (!(root == null || this.root != null && this.root.equals(root))) {
            try {
                this.root = root;
                this.libraries.setRootFolder(root);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.reload();
        }
    }

    public TestSuiteRoot getTestSuiteRoot() {
        return this.testSuiteRoot;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public JPopupMenu getPopupMenu(TreePath[] paths) {
        JPopupMenu result = null;
        if (paths != null && paths.length == 1) {
            Object lastPathComponent = paths[0].getLastPathComponent();
            if (lastPathComponent instanceof TestSuiteRoot) {
                this.rootPopupMenu.setTestSuite((TreeTestSuite)lastPathComponent);
                result = this.rootPopupMenu;
            } else if (lastPathComponent.equals(this.libraries)) {
                result = this.librariesRootPopupMenu;
            } else if (lastPathComponent instanceof TreeTestSuite) {
                TreeTestSuite testSuite = (TreeTestSuite)lastPathComponent;
                if (LibrariesRoot.isInLibraryTree((TreePathElement)lastPathComponent) || !testSuite.isLibrary() && !testSuite.isInLibrary()) {
                    this.testSuitePopupMenu.setTestSuite(testSuite);
                    result = this.testSuitePopupMenu;
                } else if (testSuite.isLibrary()) {
                    this.runRemovePopupMenu.setTest((Testable)testSuite);
                    result = this.runRemovePopupMenu;
                } else {
                    this.runPopupMenu.setTest((Testable)testSuite);
                    result = this.runPopupMenu;
                }
            } else if (lastPathComponent instanceof Testcase) {
                if (((Testcase)lastPathComponent).isInLibrary() && !LibrariesRoot.isInLibraryTree((Testcase)lastPathComponent)) {
                    this.runPreferencesPopupMenu.setTest((Testable)((Testcase)lastPathComponent));
                    result = this.runPreferencesPopupMenu;
                } else {
                    this.testPopupMenu.setTest((Testcase)lastPathComponent);
                    result = this.testPopupMenu;
                }
            } else if (lastPathComponent instanceof TestLogfile) {
                this.logfilePopupMenu.setLogfile((TestLogfile)lastPathComponent);
                result = this.logfilePopupMenu;
            } else if (lastPathComponent instanceof OptionContainer) {
                OptionContainer optionContainer = (OptionContainer)lastPathComponent;
                boolean readOnly = this.isReadOnly(optionContainer);
                this.optionsPopupMenu.setOptionContainer(optionContainer, readOnly);
                result = this.optionsPopupMenu;
            } else if (lastPathComponent instanceof TestSuiteOptions && !this.isReadOnly((TestSuiteOptions)lastPathComponent)) {
                this.testSuiteOptionsPopupMenu.setTestSuiteOptions((TestSuiteOptions)lastPathComponent);
                result = this.testSuiteOptionsPopupMenu;
            }
        } else if (paths.length > 1) {
            TestSelection testables = new TestSelection();
            for (TreePath path : paths) {
                if (!(path.getLastPathComponent() instanceof Testable)) continue;
                testables.add((Testable)path.getLastPathComponent());
            }
            this.runPopupMenu.setTests(testables);
            result = this.runPopupMenu;
        }
        return result;
    }

    private boolean isReadOnly(OptionContainer optionContainer) {
        TreeTestSuite testSuite;
        return optionContainer.getOwner() instanceof TreeTestSuite && ((testSuite = (TreeTestSuite)optionContainer.getOwner()).isLibrary() || testSuite.isInLibrary()) && !LibrariesRoot.isInLibraryTree(testSuite);
    }

    private boolean isReadOnly(TestSuiteOptions lastPathComponent) {
        TreeTestSuite parent = lastPathComponent.getParent();
        return (parent.isLibrary() || parent.isInLibrary()) && !LibrariesRoot.isInLibraryTree(parent);
    }

    public ActionListener getSelectionAction(TreeSelectionEvent event) {
        TestSelection tests = new TestSelection();
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        if (event.getNewLeadSelectionPath() == null) {
            return null;
        }
        if (event.getSource() instanceof Tree && ((Tree)event.getSource()).getSelectionPaths() != null) {
            TreePath[] selectionPaths;
            for (TreePath selectionPath : selectionPaths = ((Tree)event.getSource()).getSelectionPaths()) {
                Object selected = selectionPath.getLastPathComponent();
                ArrayList<Object> pathElements = new ArrayList<Object>();
                pathElements.add(selected);
                if (!(selected instanceof Testable)) {
                    TreePath parentPath = event.getPath().getParentPath();
                    Object object = selected = parentPath == null ? null : parentPath.getLastPathComponent();
                    while (parentPath != null && selected != null && !(selected instanceof Testable)) {
                        pathElements.add(0, selected);
                        if ((parentPath = parentPath.getParentPath()) == null) continue;
                        selected = parentPath.getLastPathComponent();
                    }
                }
                if (!(selected instanceof Testable)) continue;
                tests.add((Testable)selected);
                treePaths.add(new TreePath(pathElements.toArray()));
            }
        } else {
            Object selected = event.getNewLeadSelectionPath().getLastPathComponent();
            ArrayList<Object> pathElements = new ArrayList<Object>();
            pathElements.add(selected);
            if (!(selected instanceof Testable)) {
                TreePath parentPath = event.getPath().getParentPath();
                selected = parentPath.getLastPathComponent();
                while (parentPath != null && selected != null && !(selected instanceof Testable)) {
                    pathElements.add(0, selected);
                    if ((parentPath = parentPath.getParentPath()) == null) continue;
                    selected = parentPath.getLastPathComponent();
                }
            }
            if (!(!(selected instanceof Testable) || selected instanceof TreePathElement && LibrariesRoot.isInLibraryTree((TreePathElement)selected))) {
                tests.add((Testable)selected);
                treePaths.add(new TreePath(pathElements.toArray()));
            }
        }
        return new TestSelectedAction(tests, treePaths);
    }

    public ActionListener getExecuteAction(TreePath[] paths) {
        if (paths != null && paths.length == 1) {
            Object lastPathComponent = paths[0].getLastPathComponent();
            if (lastPathComponent instanceof OptionContainer) {
                OptionsDialog.getInstance(this.getModule()).editOptions((OptionContainer)lastPathComponent, false, false);
            } else if (lastPathComponent instanceof Testcase) {
                EventController.fire((EventObject)new EditTestPreferencesEvent((Object)this, (Testcase)lastPathComponent));
            } else if (lastPathComponent instanceof TestProperties) {
                boolean canWrite = true;
                if (paths[0].getParentPath().getLastPathComponent() instanceof Testable) {
                    canWrite = ((Testable)paths[0].getParentPath().getLastPathComponent()).canWrite();
                }
                if (canWrite) {
                    ResourceEditor.editResources((Map)((Map)lastPathComponent));
                }
            }
        }
        return super.getExecuteAction(paths);
    }

    public boolean isLeaf(Object node) {
        return !node.equals(this.root) && super.isLeaf(node);
    }

    public Object getChild(Object parent, int index) {
        Object result = parent.equals(this.root) ? (index == 0 ? this.testSuiteRoot : this.libraries) : super.getChild(parent, index);
        return result;
    }

    public int getChildCount(Object parent) {
        int result = parent.equals(this.root) ? 2 : super.getChildCount(parent);
        return result;
    }

    @Override
    public int getType(Object value) {
        int result = value instanceof TestLogfile ? 20 : super.getType(value);
        return result;
    }

    public boolean isEditable(Object node) {
        boolean result = false;
        if (node instanceof TreeTestSuite) {
            result = LibrariesRoot.isInLibraryTree((TreeTestSuite)node) || !((TreeTestSuite)node).isLibrary() && !((TreeTestSuite)node).isInLibrary();
        }
        return result;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object lastPathComponent = path.getLastPathComponent();
        String newName = newValue.toString();
        if (!(lastPathComponent instanceof Testcase) && lastPathComponent instanceof TreeTestSuite && !newName.equals(((TreeTestSuite)lastPathComponent).getName())) {
            if (((TreeTestSuite)lastPathComponent).rename(newName)) {
                EventController.fire((EventObject)new TestSuiteTreeChangedEvent((Object)this, (Testable)((TreeTestSuite)lastPathComponent)));
            } else {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("from", ((TreeTestSuite)lastPathComponent).getName());
                params.put("to", newName);
                EventController.fire((EventObject)new SendErrorEvent((Object)this, "rename.test.suite.failure", params, this.getModule().getName(), this.getModule().getDefaultMessageViewTitle()));
            }
        }
    }

    @Override
    public void reload() {
        try {
            PropertiesHelper.resetSystemProperties();
            LibraryObserver.getInstance().clear();
            File testSuiteFolder = new File(this.root, "regressiontest/testsuite");
            File rootTestSuite = new File(testSuiteFolder, "testsuite.xml");
            E2ETestSuiteTemplateFactory.getInstance().clear();
            E2ETestSuiteTemplate template = E2ETestSuiteTemplateFactory.getInstance().getTemplate(rootTestSuite, false);
            this.testSuiteRoot = new TestSuiteRoot(template);
            this.libraries.reload();
            this.fireRootChanged();
            this.fireTreeStructureChanged(new TreePath(this.root));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public LibrariesRoot getLibraries() {
        return this.libraries;
    }

    @Override
    protected void createPopupMenus(E2EBuilderModule module) {
        this.rootPopupMenu = new TestSuiteRootPopupMenu(module);
        this.testSuitePopupMenu = new TestSuitePopupMenu(module);
        this.testPopupMenu = new TestPopupMenu(module);
        this.logfilePopupMenu = new LogfilePopupMenu(module);
        this.testSuiteOptionsPopupMenu = new TestSuiteOptionsPopupMenu(module);
        this.optionsPopupMenu = new OptionsPopupMenu(module);
        this.runPopupMenu = new RunPopupMenu(module);
        this.runRemovePopupMenu = new RunRemovePopupMenu(module);
        this.runPreferencesPopupMenu = new RunPreferencesPopupMenu(module);
        this.librariesRootPopupMenu = new LibrariesRootPopupMenu(module);
    }

    private class TestSelectedAction
    implements ActionListener {
        private TestSelection tests;
        private final List<TreePath> selectedPaths;

        private TestSelectedAction(TestSelection tests, List<TreePath> selectedPaths) {
            this.tests = tests;
            this.selectedPaths = selectedPaths;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventController.fire((EventObject)new TestSelectedEvent((Object)TestSuiteRootTreeModel.this, (List)this.tests, this.selectedPaths));
        }
    }
}

