/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.model;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.event.CreateTestSuiteEvent;
import ch.e2e.builder.regtest.event.ImportLibraryEvent;
import ch.e2e.builder.regtest.event.ImportTestSuiteEvent;
import ch.e2e.builder.regtest.event.TestSuiteTreeChangedEvent;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.TestSuiteRunTransaction;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.event.EventController;
import ch.e2e.resource.ImageLoader;
import ch.e2e.test.Testable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventObject;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TestSuiteRootPopupMenu
extends JPopupMenu {
    private TreeTestSuite testSuite;
    private JMenuItem addLogfileItem;
    private JMenuItem removeLogfileItem;
    private JMenuItem runItem;
    private JMenuItem importLibraryItem;
    private JMenuItem importTestSuiteItem;
    private JMenuItem createTestSuiteItem;

    public TestSuiteRootPopupMenu(E2EBuilderModule module) {
        this.addItems(module);
    }

    public void setTestSuite(TreeTestSuite testSuite) {
        this.testSuite = testSuite;
        boolean canWrite = testSuite.canWrite();
        boolean notInLibraryTree = !LibrariesRoot.isInLibraryTree(testSuite);
        this.runItem.setEnabled(notInLibraryTree);
        this.importLibraryItem.setEnabled(canWrite && notInLibraryTree);
        File logFile = new File(testSuite.getLogFolder(), testSuite.getName() + ".log");
        boolean logFileSet = testSuite.getLogfile() != null && testSuite.getLogfile().getLogfile().equals(logFile);
        this.addLogfileItem.setEnabled(canWrite && !logFileSet);
        this.removeLogfileItem.setEnabled(canWrite && logFileSet);
        this.importTestSuiteItem.setEnabled(canWrite);
        this.createTestSuiteItem.setEnabled(canWrite);
    }

    public TreeTestSuite getTestSuite() {
        return this.testSuite;
    }

    protected void addItems(E2EBuilderModule module) {
        this.runItem = ComponentFactory.createMenuItem((String)"popup.menu.item.test.run", (E2EBuilderModule)module);
        this.runItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/run.testsuite.icon.gif", (boolean)true));
        this.runItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuiteRootPopupMenu.this.runTest();
            }
        });
        this.add(this.runItem);
        this.addModifyItems(module);
        this.addLogfileItems(module);
        this.addSeparator();
        this.importTestSuiteItem = ComponentFactory.createMenuItem((String)"popup.menu.item.import.testsuite", (E2EBuilderModule)module);
        this.importTestSuiteItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/import.testsuite.icon.gif", (boolean)true));
        this.importTestSuiteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuiteRootPopupMenu.this.importTestSuite();
            }
        });
        this.add(this.importTestSuiteItem);
        this.createTestSuiteItem = ComponentFactory.createMenuItem((String)"popup.menu.item.create.testsuite", (E2EBuilderModule)module);
        this.createTestSuiteItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/create.testsuite.icon.gif", (boolean)true));
        this.createTestSuiteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuiteRootPopupMenu.this.createTestSuite();
            }
        });
        this.add(this.createTestSuiteItem);
        this.addTescasesItems(module);
        this.addLibraryItems(module);
    }

    protected void addModifyItems(E2EBuilderModule module) {
    }

    protected void addTescasesItems(E2EBuilderModule module) {
    }

    protected void addLibraryItems(E2EBuilderModule module) {
        this.addSeparator();
        this.importLibraryItem = ComponentFactory.createMenuItem((String)"popup.menu.item.library.import", (E2EBuilderModule)module);
        this.importLibraryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuiteRootPopupMenu.this.importLibrary();
            }
        });
        this.add(this.importLibraryItem);
    }

    protected void addLogfileItems(E2EBuilderModule module) {
        this.addSeparator();
        this.addLogfileItem = ComponentFactory.createMenuItem((String)"popup.menu.item.add.logfile", (E2EBuilderModule)module);
        this.addLogfileItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/logfile.add.icon.gif", (boolean)true));
        this.addLogfileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuiteRootPopupMenu.this.addLogfile();
            }
        });
        this.add(this.addLogfileItem);
        this.removeLogfileItem = ComponentFactory.createMenuItem((String)"popup.menu.item.remove.logfile", (E2EBuilderModule)module);
        this.removeLogfileItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/logfile.remove.icon.gif", (boolean)true));
        this.removeLogfileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuiteRootPopupMenu.this.removeLogfile();
            }
        });
        this.add(this.removeLogfileItem);
    }

    private void importTestSuite() {
        EventController.fire((EventObject)new ImportTestSuiteEvent(this, this.testSuite, 0));
    }

    private void runTest() {
        EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)new TestSuiteRunTransaction(), (Object)this.testSuite));
    }

    private void createTestSuite() {
        EventController.fire((EventObject)new CreateTestSuiteEvent(this, this.testSuite, 0));
    }

    private void importLibrary() {
        EventController.fire((EventObject)new ImportLibraryEvent(this, this.getTestSuite(), 0));
    }

    private void removeLogfile() {
        this.getTestSuite().removeLogfile();
        EventController.fire((EventObject)new TestSuiteTreeChangedEvent(this, (Testable)this.getTestSuite()));
    }

    private void addLogfile() {
        this.getTestSuite().addLogfile();
        EventController.fire((EventObject)new TestSuiteTreeChangedEvent(this, (Testable)this.getTestSuite()));
    }
}

