/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.AbstractOptionPanel;
import ch.e2e.builder.regtest.gui.swing.FileOptionPane;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedEvent;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedListener;
import ch.e2e.test.CompareFile;
import ch.e2e.test.options.CompareFileOption;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.border.TitledBorder;

public class CompareFileOptionPane
extends AbstractOptionPanel<CompareFile, CompareFileOption> {
    private TitledBorder titledBorder;
    private CompareFileOption option;
    private FileOptionPane filePane;

    public CompareFileOptionPane() {
        super(new BorderLayout());
        this.createGui();
    }

    @Override
    public boolean isEmpty() {
        return this.filePane.isEmpty();
    }

    @Override
    public CompareFile getValue() {
        return new CompareFile(this.filePane.getValue());
    }

    @Override
    public void setValue(CompareFile value) {
        this.filePane.setValue(value == null ? null : value.getFile());
    }

    @Override
    public void persist(boolean forced) {
        this.filePane.persist(false);
        super.persist(forced);
    }

    @Override
    public CompareFileOption getOption() {
        return this.option;
    }

    @Override
    public void setOption(CompareFileOption option) {
        this.option = option;
        this.titledBorder.setTitle(option.getName());
        this.filePane.setOption(option.getFileOption());
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.filePane.setReadOnly(readOnly);
    }

    @Override
    public void setChanged(boolean changed) {
        super.setChanged(changed);
        this.filePane.setChanged(changed);
    }

    private void createGui() {
        this.setLayout(new GridBagLayout());
        this.titledBorder = new TitledBorder("");
        this.setBorder(this.titledBorder);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.gridwidth = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(4, 0, 2, 7);
        this.filePane = new FileOptionPane();
        this.add((Component)this.filePane, c);
        this.filePane.addOptionChangedListener(new OptionInputChangedListener(){

            @Override
            public void optionChanged(OptionInputChangedEvent event) {
                CompareFileOptionPane.this.fireOptionInputChanged();
                CompareFileOptionPane.this.setChanged(true);
            }
        });
        c.weighty = 1.0;
    }
}

