/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing.tree;

import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.traceviewer.TraceViewer;
import ch.e2e.builder.traceviewer.swing.MainPanel;
import ch.e2e.builder.traceviewer.swing.tree.AsynchronousTreeView;
import ch.e2e.builder.traceviewer.swing.tree.SynchronousTreeView;
import ch.e2e.builder.traceviewer.testcase.AsynchronousTestcaseRoot;
import ch.e2e.builder.traceviewer.testcase.SynchronousTestcaseRoot;
import ch.e2e.io.FilesNotDeletedException;
import com.jidesoft.swing.JideSplitPane;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.tree.TreePath;

public class TreeViewPane
extends JideSplitPane {
    private SynchronousTestcaseRoot synchronousRoot;
    private AsynchronousTestcaseRoot asynchronousRoot;
    private final MainPanel mainPanel;
    private TraceViewer traceViewer;
    private AsynchronousTreeView asynchronousTreeView;
    private SynchronousTreeView synchronousTreeView;

    public TreeViewPane(MainPanel mainPanel, SynchronousTestcaseRoot synchronousRoot, AsynchronousTestcaseRoot asynchronousRoot, TraceViewer traceViewer) {
        super(0);
        this.setContinuousLayout(true);
        this.mainPanel = mainPanel;
        this.synchronousRoot = synchronousRoot;
        this.asynchronousRoot = asynchronousRoot;
        this.traceViewer = traceViewer;
        this.createGui();
    }

    private void createGui() {
        this.synchronousTreeView = new SynchronousTreeView(this.synchronousRoot, this.mainPanel, (E2EBuilderModule)this.traceViewer);
        this.synchronousTreeView.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TreePath selectionPath;
                if (e.getOppositeComponent() != TreeViewPane.this.mainPanel.getActualView() && (selectionPath = TreeViewPane.this.synchronousTreeView.getTree().getSelectionPath()) != null && selectionPath.getLastPathComponent() != TreeViewPane.this.synchronousTreeView.getMainPanel().getRoot()) {
                    TreeViewPane.this.synchronousTreeView.getMainPanel().pathChanged(selectionPath);
                }
            }
        });
        this.addPane(this.synchronousTreeView);
        this.asynchronousTreeView = new AsynchronousTreeView(this.asynchronousRoot, this.mainPanel, this.traceViewer);
        this.asynchronousTreeView.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TreePath selectionPath;
                if (e.getOppositeComponent() != TreeViewPane.this.mainPanel.getActualView() && (selectionPath = TreeViewPane.this.asynchronousTreeView.getTree().getSelectionPath()) != null && selectionPath.getLastPathComponent() != TreeViewPane.this.mainPanel.getRoot()) {
                    TreeViewPane.this.asynchronousTreeView.getMainPanel().pathChanged(selectionPath);
                }
            }
        });
        this.addPane(this.asynchronousTreeView);
        this.traceViewer.enableMenuEntries(this.synchronousTreeView.getClass());
        this.traceViewer.enableMenuEntries(this.asynchronousTreeView.getClass());
    }

    public void refresh(boolean deep) throws FilesNotDeletedException, WrongIDFileVersionException {
        if (deep) {
            this.synchronousRoot.refresh();
            this.synchronousTreeView.refresh();
            this.asynchronousRoot.refresh();
            this.asynchronousTreeView.refresh();
        }
    }

    public void refresh() throws FilesNotDeletedException, WrongIDFileVersionException {
        this.refresh(false);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.synchronousTreeView.setEnabled(enabled);
        this.asynchronousTreeView.setEnabled(enabled);
    }
}

