/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.transformer;

import ch.e2e.io.ZipUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.transformer.E2EURIResolver;
import ch.e2e.transformer.LoadListenerMulticaster;
import ch.e2e.transformer.Logging;
import ch.e2e.transformer.TransformerLoadException;
import ch.e2e.transformer.TransformerLoadListener;
import java.io.File;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class TransformerLoader
implements Logging {
    private String filesystemExtension = "xsl";
    private String classpathExtension = "bin";
    private File transformerPath;
    private Properties properties;
    private static TransformerFactory transformerFactory;
    private TransformerLoadListener listener = null;
    private ErrorListener defaultErrorListener;
    private ClassLoader classLoader;

    public TransformerLoader(String transformerPath) {
        this(transformerPath == null ? null : new File(transformerPath), null, TransformerLoader.class.getClassLoader());
    }

    public TransformerLoader(String transformerPath, ClassLoader classLoader) {
        this(transformerPath == null ? null : new File(transformerPath), null, classLoader);
    }

    public TransformerLoader(String transformerPath, Properties properties) {
        this(transformerPath == null ? null : new File(transformerPath), properties, TransformerLoader.class.getClassLoader());
    }

    public TransformerLoader(String transformerPath, Properties properties, ClassLoader classLoader) {
        this(transformerPath == null ? null : new File(transformerPath), properties, classLoader);
    }

    public TransformerLoader(File transformerPath) {
        this(transformerPath, null, TransformerLoader.class.getClassLoader());
    }

    public TransformerLoader(File transformerPath, ClassLoader classLoader) {
        this(transformerPath, null, classLoader);
    }

    public TransformerLoader(File transformerPath, Properties properties) {
        this(transformerPath, properties, TransformerLoader.class.getClassLoader());
    }

    public TransformerLoader(File transformerPath, Properties properties, ClassLoader classLoader) {
        this.transformerPath = transformerPath;
        this.properties = properties;
        this.classLoader = classLoader;
        this.defaultErrorListener = transformerFactory.getErrorListener();
    }

    public static TransformerFactory getTransformerFactory() {
        return transformerFactory;
    }

    public void addTransformerLoadListener(TransformerLoadListener listener) {
        this.listener = LoadListenerMulticaster.addListener(this.listener, listener);
    }

    public void removeTransformerLoadListener(TransformerLoadListener listener) {
        this.listener = LoadListenerMulticaster.removeListener(this.listener, listener);
    }

    public void setFilesystemExtension(String filesystemExtension) {
        this.filesystemExtension = filesystemExtension;
    }

    public void setClasspathExtension(String classpathExtension) {
        this.classpathExtension = classpathExtension;
    }

    public Transformer getTransformer(String transformerStr) throws TransformerLoadException {
        return this.getTransformer(transformerStr, this.classpathExtension, this.filesystemExtension);
    }

    public Transformer getTransformer(String transformerStr, String classpathExtension, String filesystemExtension) throws TransformerLoadException {
        if (this.properties != null) {
            transformerStr = this.properties.getString(transformerStr, transformerStr);
        }
        Transformer transformer = this.transformerPath == null ? this.loadTransformerFromClasspath(transformerStr, classpathExtension) : this.loadTransformerFromFileSystem(transformerStr, filesystemExtension);
        return transformer;
    }

    public Transformer getTransformer(File scriptFile) throws TransformerLoadException {
        return this.loadTransformerFromFile(scriptFile);
    }

    public void setErrorListener(ErrorListener errorListener) {
        transformerFactory.setErrorListener(errorListener);
    }

    public void removeErrorListener() {
        transformerFactory.setErrorListener(this.defaultErrorListener);
    }

    private Transformer loadTransformerFromFileSystem(String transformerStr, String extension) throws TransformerLoadException {
        File scriptFile = new File(this.transformerPath, transformerStr + "." + extension);
        return this.loadTransformerFromFile(scriptFile);
    }

    private Transformer loadTransformerFromFile(File scriptFile) throws TransformerLoadException {
        if (this.listener != null) {
            this.listener.startLoadingFromFileSystem(scriptFile.getAbsolutePath());
        }
        try {
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(scriptFile));
            if (this.listener != null) {
                this.listener.loadedFromFileSystem(scriptFile.getAbsolutePath());
            }
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "loadTransformerFromFile", e);
            throw new TransformerLoadException("Could not load the tranformer from the file\"" + scriptFile.getAbsolutePath() + "\"", e);
        }
    }

    private Transformer loadTransformerFromClasspath(String transformerStr, String extension) throws TransformerLoadException {
        String zipTransformer = transformerStr + "." + extension;
        if (this.listener != null) {
            this.listener.startLoadingFromClasspath(zipTransformer);
        }
        try {
            Document doc = ZipUtilities.getZippedDocumentFromClasspath(zipTransformer, this.classLoader);
            Transformer transformer = transformerFactory.newTransformer(new DOMSource(doc));
            if (this.listener != null) {
                this.listener.loadedFromClasspath(zipTransformer);
            }
            return transformer;
        }
        catch (Exception ex) {
            logger.throwing(this.getClass().getName(), "loadTransformerFromClasspath", ex);
            throw new TransformerLoadException("Could not load the transformer \"" + zipTransformer + "\" from classpath", ex);
        }
    }

    public Templates getTemplates(String transformerStr) throws TransformerLoadException {
        return this.getTemplates(transformerStr, this.classpathExtension, this.filesystemExtension);
    }

    public Templates getTemplates(String transformerStr, String classpathExtension, String filesystemExtension) throws TransformerLoadException {
        if (this.properties != null) {
            transformerStr = this.properties.getString(transformerStr, transformerStr);
        }
        Templates transformer = this.transformerPath == null ? this.loadTemplatesFromClasspath(transformerStr, classpathExtension) : this.loadTemplatesFromFileSystem(transformerStr, filesystemExtension);
        return transformer;
    }

    public Templates getTemplates(File scriptFile) throws TransformerLoadException {
        return this.loadTemplatesFromFile(scriptFile);
    }

    private Templates loadTemplatesFromFileSystem(String transformerStr, String extension) throws TransformerLoadException {
        File scriptFile = new File(this.transformerPath, transformerStr + "." + extension);
        return this.loadTemplatesFromFile(scriptFile);
    }

    private Templates loadTemplatesFromFile(File scriptFile) throws TransformerLoadException {
        if (this.listener != null) {
            this.listener.startLoadingFromFileSystem(scriptFile.getAbsolutePath());
        }
        try {
            Templates transformer = transformerFactory.newTemplates(new StreamSource(scriptFile));
            if (this.listener != null) {
                this.listener.loadedFromFileSystem(scriptFile.getAbsolutePath());
            }
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "loadTemplatesFromFile", e);
            throw new TransformerLoadException("Could not load the templates from the file\"" + scriptFile.getAbsolutePath() + "\"", e);
        }
    }

    private Templates loadTemplatesFromClasspath(String transformerStr, String extension) throws TransformerLoadException {
        String zipTemplates = transformerStr + "." + extension;
        if (this.listener != null) {
            this.listener.startLoadingFromClasspath(zipTemplates);
        }
        try {
            Document doc = ZipUtilities.getZippedDocumentFromClasspath(zipTemplates, this.classLoader);
            Templates transformer = transformerFactory.newTemplates(new DOMSource(doc));
            if (this.listener != null) {
                this.listener.loadedFromClasspath(zipTemplates);
            }
            return transformer;
        }
        catch (Exception ex) {
            logger.throwing(this.getClass().getName(), "loadTemplatesFromClasspath", ex);
            throw new TransformerLoadException("Could not load the templates \"" + zipTemplates + "\" from classpath", ex);
        }
    }

    static {
        try {
            Class<?> factoryClass;
            try {
                factoryClass = TransformerLoader.class.getClassLoader().loadClass("net.sf.saxon.TransformerFactoryImpl");
            }
            catch (ClassNotFoundException e) {
                factoryClass = TransformerLoader.class.getClassLoader().loadClass("com.icl.saxon.TransformerFactoryImpl");
            }
            transformerFactory = (TransformerFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            logger.finest("Could not load the saxon TransformerFactory, loading deafult factory");
            transformerFactory = TransformerFactory.newInstance();
        }
        transformerFactory.setURIResolver(new E2EURIResolver(transformerFactory.getURIResolver()));
    }
}

