/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ptree;

import com.saxonica.config.ProfessionalConfiguration;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.PrefixPool;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.AppendableCharSequence;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.z.IntToIntHashMap;
import net.sf.saxon.z.IntToIntMap;
import org.xml.sax.SAXParseException;

public class PTreeWriter {
    private Configuration config;
    private NamePool pool;
    private List<String[]> names;
    private IntToIntMap nameCodeMap;
    private int version = 1;

    public PTreeWriter(ProfessionalConfiguration config) {
        this.config = config;
        config.checkLicensedFeature(8, "PTree writer", -1);
        this.names = new ArrayList<String[]>(500);
        this.nameCodeMap = new IntToIntHashMap(500);
        this.nameCodeMap.setDefaultValue(-1);
    }

    public void setPTreeVersion(int version) {
        if (version != 1) {
            throw new IllegalArgumentException("version must be 1");
        }
        this.version = version;
    }

    public void writeTree(TinyTree tree, DataOutputStream out) throws IOException, XPathException {
        if (tree.containsGraftedSubtrees()) {
            TinyBuilder builder = new TinyBuilder(this.config.makePipelineConfiguration());
            tree.getRootNode().copy(builder, 2, ExplicitLocation.UNKNOWN_LOCATION);
            this.writeTree(builder.getTree(), out);
            return;
        }
        int numberOfNodes = tree.getNumberOfNodes();
        int[] nameCodes = tree.getNameCodeArray();
        byte[] nodeKind = tree.getNodeKindArray();
        short[] depth = tree.getNodeDepthArray();
        SchemaType[] typeArray = tree.getTypeArray();
        int[] typeCodes = null;
        if (typeArray != null) {
            for (int i = 0; i < typeArray.length; ++i) {
                int t = typeArray[i].getFingerprint();
                if (tree.isNilled(i)) {
                    t |= 0x20000000;
                }
                typeCodes[i] = t;
            }
        }
        int[] alpha = tree.getAlphaArray();
        int[] beta = tree.getBetaArray();
        AppendableCharSequence text = tree.getCharacterBuffer();
        CharSequence comments = tree.getCommentBuffer();
        int numberOfAttributes = tree.getNumberOfAttributes();
        int[] attributeNameCodes = tree.getAttributeNameCodeArray();
        int[] attributeParentPointers = tree.getAttributeParentArray();
        SimpleType[] attributeTypes = tree.getAttributeTypeArray();
        int[] attributeTypeCodes = null;
        if (attributeTypes != null) {
            attributeTypeCodes = new int[attributeTypes.length];
            for (int i = 0; i < attributeTypes.length; ++i) {
                int t = attributeTypes[i].getFingerprint();
                if (tree.isIdrefAttribute(i)) {
                    t |= 0x20000000;
                }
                typeCodes[i] = t;
            }
        }
        CharSequence[] attributeValues = tree.getAttributeValueArray();
        int numberOfNamespaces = tree.getNumberOfNamespaces();
        NamespaceBinding[] namespaceCodes = tree.getNamespaceBindings();
        int[] namespaceParents = tree.getNamespaceParentArray();
        this.pool = tree.getNamePool();
        out.writeInt(-1091982307);
        out.writeInt(this.version);
        out.writeInt(0);
        out.writeInt(numberOfNodes);
        out.writeInt(numberOfAttributes);
        out.writeInt(numberOfNamespaces);
        out.writeInt(text.length());
        this.handleNames(tree.getPrefixPool(), out, nameCodes, typeCodes, attributeNameCodes, attributeTypeCodes);
        block13: for (int i = 0; i < numberOfNodes; ++i) {
            int depthCode = i == 0 || depth[i] == depth[i - 1] ? 0 : (depth[i] == depth[i - 1] + 1 ? 1 : (depth[i] <= 255 ? 2 : 3));
            out.writeByte(nodeKind[i] | depthCode << 6);
            if (depthCode == 2) {
                out.writeByte(depth[i]);
            } else if (depthCode == 3) {
                out.writeInt(depth[i]);
            }
            switch (nodeKind[i]) {
                case 9: {
                    continue block13;
                }
                case 1: {
                    int a;
                    int nc = this.allocateNameCode(tree.getPrefixPool(), nameCodes[i]);
                    int nameCodeSize = this.integerLength(nc);
                    int options = nameCodeSize - 1 << 6;
                    options |= alpha[i] >= 0 ? 32 : 0;
                    options |= beta[i] >= 0 ? 16 : 0;
                    int typeCodeSize = 0;
                    int tc = 0;
                    if (typeCodes != null && typeCodes[i] >= 0) {
                        tc = this.allocateNameCode(tree.getPrefixPool(), (int)typeCodes[i]);
                        typeCodeSize = this.integerLength(tc);
                        options |= (typeCodeSize & 3) << 2;
                    }
                    out.writeByte(options);
                    this.writeVariableInt(out, nc, nameCodeSize);
                    if (typeCodeSize > 0) {
                        this.writeVariableInt(out, tc, typeCodeSize);
                    }
                    if (beta[i] >= 0) {
                        int ns = beta[i];
                        int nss = 0;
                        while (ns < numberOfNamespaces && namespaceParents[ns++] == i) {
                            ++nss;
                        }
                        out.writeShort(nss);
                        for (a = 0; a < nss; ++a) {
                            NamespaceBinding nscode = namespaceCodes[beta[i] + a];
                            out.writeUTF(nscode.getPrefix());
                            out.writeUTF(nscode.getURI());
                        }
                    }
                    if (alpha[i] < 0) continue block13;
                    int att = alpha[i];
                    int atts = 0;
                    while (att < numberOfAttributes && attributeParentPointers[att++] == i) {
                        ++atts;
                    }
                    out.writeShort(atts);
                    for (a = 0; a < atts; ++a) {
                        int ai = alpha[i] + a;
                        int newTypeCode = -1;
                        boolean isId = tree.isIdAttribute(ai);
                        boolean isIdref = tree.isIdrefAttribute(ai);
                        if (attributeTypeCodes != null && attributeTypeCodes[ai] >= 0) {
                            int fp = attributeTypeCodes[ai] & 0xDFFFFFFF;
                            newTypeCode = this.allocateNameCode(tree.getPrefixPool(), fp);
                        }
                        this.writeAttribute(out, this.allocateNameCode(tree.getPrefixPool(), attributeNameCodes[alpha[i] + a]), newTypeCode, isId, isIdref, attributeValues[alpha[i] + a].toString());
                    }
                    continue block13;
                }
                case 17: {
                    int nc = this.allocateNameCode(tree.getPrefixPool(), nameCodes[i]);
                    int nameCodeSize = this.integerLength(nc);
                    int options = nameCodeSize - 1 << 6;
                    options |= alpha[i] >= 0 ? 32 : 0;
                    options |= beta[i] >= 0 ? 16 : 0;
                    int typeCodeSize = 0;
                    int tc = 0;
                    if (typeCodes != null && typeCodes[i] >= 0) {
                        tc = this.allocateNameCode(tree.getPrefixPool(), (int)typeCodes[i]);
                        typeCodeSize = this.integerLength(tc);
                        options |= (typeCodeSize & 3) << 2;
                    }
                    out.writeByte(options);
                    this.writeVariableInt(out, nc, nameCodeSize);
                    if (typeCodeSize > 0) {
                        this.writeVariableInt(out, tc, typeCodeSize);
                    }
                    String value = TinyTextImpl.getStringValue(tree, i).toString();
                    this.writeString(value, out, "");
                    continue block13;
                }
                case 3: {
                    String value = TinyTextImpl.getStringValue(tree, i).toString();
                    this.writeString(value, out, "");
                    continue block13;
                }
                case 4: {
                    byte b;
                    int s;
                    long val = WhitespaceTextImpl.getLongValue(tree, i);
                    int count = 0;
                    for (s = 56; s >= 0 && (b = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
                        count = (byte)(count + 1);
                    }
                    out.writeByte(count);
                    for (s = 56; s >= 0 && (b = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
                        out.writeByte(b);
                    }
                    continue block13;
                }
                case 8: {
                    String comment = comments.subSequence(alpha[i], alpha[i] + beta[i]).toString();
                    this.writeString(comment, out, "--");
                    continue block13;
                }
                case 7: {
                    String name = this.pool.getLocalName(nameCodes[i]);
                    out.writeUTF(name);
                    String data = comments.subSequence(alpha[i], alpha[i] + beta[i]).toString();
                    this.writeString(data, out, "?>");
                    continue block13;
                }
                case 12: {
                    continue block13;
                }
                case 33: {
                    throw new AssertionError();
                }
            }
        }
        out.flush();
    }

    private void writeVariableInt(DataOutputStream out, int value, int bytes) throws IOException {
        if (bytes == 4) {
            out.writeInt(value);
        } else if (bytes == 3) {
            out.writeByte(value >>> 16);
            out.writeByte(value >>> 8);
            out.writeByte(value);
        } else if (bytes == 2) {
            out.writeByte(value >>> 8);
            out.writeByte(value);
        } else if (bytes == 1) {
            out.writeByte(value);
        }
    }

    private void handleNames(PrefixPool prefixPool, DataOutputStream out, int[] enames, int[] etypes, int[] anames, int[] atypes) throws IOException {
        this.indexNames(prefixPool, enames, -1);
        this.indexNames(prefixPool, etypes, -1);
        this.indexNames(prefixPool, anames, -1);
        this.indexNames(prefixPool, atypes, -536870913);
        out.writeInt(this.names.size());
        HashMap<String, Short> uris = new HashMap<String, Short>(16);
        ArrayList<String> uriList = new ArrayList<String>(16);
        HashMap<String, Short> prefixes = new HashMap<String, Short>(16);
        ArrayList<String> prefixList = new ArrayList<String>(16);
        for (String[] name : this.names) {
            Short uriCode;
            String[] triple = name;
            Short prefixCode = (Short)prefixes.get(triple[0]);
            if (prefixCode == null) {
                prefixCode = (short)prefixes.size();
                prefixes.put(triple[0], prefixCode);
                prefixList.add(triple[0]);
            }
            if ((uriCode = (Short)uris.get(triple[1])) == null) {
                uriCode = (short)uris.size();
                uris.put(triple[1], uriCode);
                uriList.add(triple[1]);
            }
            out.writeShort(prefixCode.shortValue());
            out.writeShort(uriCode.shortValue());
            if (triple[2] == null) {
                triple[2] = "";
            }
            out.writeUTF(triple[2]);
        }
        out.writeInt(prefixes.size());
        for (String prefix : prefixList) {
            out.writeUTF(prefix);
        }
        out.writeInt(uris.size());
        for (String uri : uriList) {
            out.writeUTF(uri);
        }
    }

    private void indexNames(PrefixPool prefixPool, int[] codes, int mask) {
        if (codes != null) {
            for (int code : codes) {
                if (code <= 0) continue;
                this.allocateNameCode(prefixPool, code & mask);
            }
        }
    }

    private int allocateNameCode(PrefixPool prefixPool, int oldNameCode) {
        int nc = this.nameCodeMap.get(oldNameCode);
        if (nc == -1) {
            String prefix = prefixPool.getPrefix(oldNameCode >> 20);
            String uri = this.pool.getURI(oldNameCode);
            String localName = this.pool.getLocalName(oldNameCode);
            String[] triple = new String[]{prefix, uri, localName};
            int newNameCode = this.names.size();
            this.names.add(triple);
            this.nameCodeMap.put(oldNameCode, newNameCode);
            return newNameCode;
        }
        return nc;
    }

    private int integerLength(int i) {
        if (i < 0) {
            return 4;
        }
        if (i < 255) {
            return 1;
        }
        if (i < 65535) {
            return 2;
        }
        if (i < 0x1000000) {
            return 3;
        }
        return 4;
    }

    private void writeAttribute(DataOutputStream out, int nc, int typeCode, boolean isId, boolean isIdref, String value) throws IOException {
        int nameCodeSize = this.integerLength(nc);
        int options = nameCodeSize - 1 << 6;
        int typeCodeSize = this.integerLength(typeCode);
        if (typeCode >= 0) {
            options |= (typeCodeSize & 3) << 4;
        }
        options |= isId ? 1 : 0;
        options |= isIdref ? 2 : 0;
        out.writeByte(options |= value.isEmpty() ? 0 : 8);
        this.writeVariableInt(out, nc, nameCodeSize);
        if (typeCode >= 0) {
            this.writeVariableInt(out, typeCode, typeCodeSize);
        }
        if (!value.isEmpty()) {
            this.writeString(value, out, "");
        }
    }

    private void writeString(String value, DataOutputStream out, String signal) throws IOException {
        try {
            out.writeUTF(value);
        }
        catch (UTFDataFormatException err) {
            out.writeUTF(signal);
            this.writeLongString(value, out, signal);
        }
    }

    private void writeLongString(CharSequence chars, DataOutputStream out, String signal) throws IOException {
        if (chars == null) {
            chars = signal;
        }
        int length = chars.length();
        int globs = length / 10000;
        if (length % 10000 != 0) {
            ++globs;
        }
        int start = 0;
        out.writeInt(globs);
        for (int i = 0; i < globs; ++i) {
            out.writeUTF(chars.subSequence(start, Math.min(start + 10000, length)).toString());
            start += 10000;
        }
    }

    private static TreeInfo build(File in, boolean stripSpace) throws XPathException {
        StreamSource source = new StreamSource(in.toURI().toString());
        ParseOptions options = new ParseOptions();
        if (stripSpace) {
            options.setSpaceStrippingRule(AllElementsSpaceStrippingRule.getInstance());
        }
        ProfessionalConfiguration config = new ProfessionalConfiguration();
        try {
            return config.buildDocumentTree(source, options);
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if ((cause = spe.getException()) instanceof RuntimeException) {
                    config.reportFatalError(err);
                }
            } else {
                while (err.getException() instanceof XPathException) {
                    err = (XPathException)err.getException();
                }
                config.reportFatalError(err);
            }
            throw err;
        }
    }

    public static void copyToPTree(Source in, ParseOptions options, OutputStream out) throws XPathException, IOException {
        DataOutputStream outs = new DataOutputStream(out);
        ProfessionalConfiguration config = new ProfessionalConfiguration();
        ParseOptions opt2 = new ParseOptions(options);
        opt2.setModel(TreeModel.TINY_TREE);
        TinyDocumentImpl doc = (TinyDocumentImpl)config.buildDocumentTree(in, opt2).getRootNode();
        new PTreeWriter(config).writeTree(doc.getTree(), outs);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Format: java com.saxonica.PTreeWriter [-strip] source.xml out.tree");
            System.exit(2);
        }
        int a = 0;
        boolean stripSpace = false;
        int version = 1;
        if (args[a].equals("-strip")) {
            stripSpace = true;
        }
        int n = ++a;
        File in = new File(args[n]);
        TreeInfo doc = PTreeWriter.build(in, stripSpace);
        File out = new File(args[++a]);
        DataOutputStream outs = new DataOutputStream(new FileOutputStream(out));
        TinyTree tree = (TinyTree)doc;
        PTreeWriter writer = new PTreeWriter((ProfessionalConfiguration)doc.getConfiguration());
        writer.setPTreeVersion(version);
        writer.writeTree(tree, outs);
        outs.close();
    }
}

