/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.renderer;

import ch.e2e.swing.renderer.RendererPreferences;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class CellRenderer
extends DefaultTreeCellRenderer {
    private RendererPreferences rendererPreferences;

    public CellRenderer(RendererPreferences rendererPreferences) {
        this.rendererPreferences = rendererPreferences;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        int type = this.rendererPreferences.getType(value);
        String valueStr = this.rendererPreferences.toString(value);
        super.getTreeCellRendererComponent(tree, valueStr, selected, expanded, leaf, row, hasFocus);
        if (type == -1) {
            this.setFont(this.getFont().deriveFont(0));
            if (selected) {
                this.setForeground(this.rendererPreferences.getDefaultSelectedForeground());
                this.setBackground(this.rendererPreferences.getDefaultSelectedBackground());
            }
        } else {
            if (selected) {
                this.setSelectedColors(type);
            } else {
                this.setColor(type, leaf, expanded);
            }
            this.setIcon(type, leaf, expanded, selected);
            this.setFont(this.getFont().deriveFont(this.rendererPreferences.getFontStyle(type)));
        }
        this.setToolTipText(this.rendererPreferences.getTooltip(value));
        return this;
    }

    private void setIcon(int type, boolean leaf, boolean expanded, boolean selected) {
        Icon[] icons = this.rendererPreferences.getIcons(type, leaf, expanded, selected);
        if (icons[0] != null) {
            this.setIcon(icons[0]);
            this.setDisabledIcon(icons[1]);
        }
    }

    private void setColor(int type, boolean leaf, boolean expanded) {
        Color color = this.rendererPreferences.getColor(type, leaf, expanded);
        if (color != null) {
            this.setForeground(color);
        }
    }

    private void setSelectedColors(int type) {
        Color[] colors = this.rendererPreferences.getSelectedColors(type);
        if (colors[0] != null) {
            this.setBackgroundSelectionColor(colors[0]);
        }
        if (colors[1] != null) {
            this.setForeground(colors[1]);
        }
    }
}

