/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.swing.document.FileTextFieldDocument;
import ch.e2e.swing.event.FileSelectedEvent;
import ch.e2e.swing.event.FileSelectedEventMulticaster;
import ch.e2e.swing.event.FileSelectedListener;
import ch.e2e.swing.filechooser.FileTextField;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class FilenameField
extends FileTextField
implements FileSelectedListener {
    private FileSelectedListener fileListener;
    private boolean fireSelected = true;

    public FilenameField() {
        super(new FileTextFieldDocument());
        this.addEventHandler();
    }

    public void setSelectionMode(int selectionMode) {
        ((FileTextFieldDocument)this.getDocument()).setMultipleSelection(selectionMode == 2);
    }

    @Override
    public void fileSelected(FileSelectedEvent event) {
        this.fireSelected = false;
        this.setFiles(event.getFiles());
        this.fireSelected = true;
    }

    public void addFileSelectedListener(FileSelectedListener listener) {
        this.fileListener = FileSelectedEventMulticaster.addListener(this.fileListener, listener);
    }

    public void removeFileSelectedListener(FileSelectedListener listener) {
        this.fileListener = FileSelectedEventMulticaster.removeListener(this.fileListener, listener);
    }

    public void setFiles(File[] files) {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            if (text.length() > 0) {
                text.append('|');
            }
            if (this.selectedDirectory == null || files[i] == null || !files[i].getParentFile().equals(this.selectedDirectory.getDir())) continue;
            text.append(files[i].getName());
        }
        this.setText(text.toString());
        if (this.fireSelected) {
            this.fireFileSelected();
        }
    }

    @Override
    public File[] getFiles() {
        StringTokenizer tokenizer = new StringTokenizer(this.getText(), "|");
        ArrayList<File> files = new ArrayList<File>();
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            File file = this.selectedDirectory != null ? new File(this.selectedDirectory.getDir(), nextToken) : new File(nextToken);
            files.add(file);
        }
        File[] fileArray = new File[files.size()];
        files.toArray(fileArray);
        return fileArray;
    }

    private void addEventHandler() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                FilenameField.this.fireFileSelected();
            }
        });
    }

    private void fireFileSelected() {
        if (this.fileListener != null) {
            FileSelectedEvent event = new FileSelectedEvent(this, this.getFiles());
            this.fileListener.fileSelected(event);
        }
    }
}

