/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.border.SmallBevelBorder;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class TitleButton
extends JButton {
    private Border raisedBorder;
    private Border loweredBorder;

    public TitleButton(Icon icon) {
        super(icon);
        this.setPressedIcon(icon);
        this.setFocusPainted(false);
        this.setBorder(new BevelBorder(0));
        this.raisedBorder = new SmallBevelBorder(2);
        this.loweredBorder = new SmallBevelBorder(1);
        this.setBorder(this.raisedBorder);
        this.setFocusPainted(false);
        this.addMouseListener(new MouseEventHandler());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(13, 13);
    }

    private class MouseEventHandler
    extends MouseAdapter {
        private boolean pressed = false;

        private MouseEventHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (TitleButton.this.isEnabled()) {
                TitleButton.this.setBorder(TitleButton.this.loweredBorder);
                this.pressed = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.pressed = false;
            TitleButton.this.setBorder(TitleButton.this.raisedBorder);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.pressed) {
                TitleButton.this.setBorder(TitleButton.this.loweredBorder);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TitleButton.this.setBorder(TitleButton.this.raisedBorder);
        }
    }
}

