/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.InputField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.InputListCellRenderer;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InputList
extends JList
implements InputField {
    private InputFieldListener listener;
    private ActionListener actionListener;
    private List elements;

    public InputList() {
        this.initialize(new ArrayList());
    }

    public InputList(List listObjects) {
        this.initialize(listObjects);
    }

    public InputList(Object[] listObjects) {
        this.initialize(Arrays.asList(listObjects));
    }

    public InputList(DefaultListModel listModel) {
        super(listModel);
        this.elements = Arrays.asList(listModel.toArray());
        this.addEventHandler();
    }

    public void addListElement(Object listElement) {
        ((DefaultListModel)this.getModel()).addElement(listElement);
    }

    public void insertListElementAt(Object listElement, int index) {
        ((DefaultListModel)this.getModel()).add(index, listElement);
    }

    @Override
    public Object getContent() {
        return this.getSelectedValues();
    }

    @Override
    public void setContent(Object value) {
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            int[] selectedIndices = new int[values.length];
            for (int i = 0; i < selectedIndices.length; ++i) {
                selectedIndices[i] = this.elements.indexOf(values[i]);
            }
            this.setSelectedIndices(selectedIndices);
        } else if (value instanceof List) {
            List values = (List)value;
            int[] selectedIndices = new int[values.size()];
            for (int i = 0; i < selectedIndices.length; ++i) {
                selectedIndices[i] = this.elements.indexOf(values.get(i));
            }
            this.setSelectedIndices(selectedIndices);
        } else {
            this.setSelectedValue(value, true);
        }
    }

    public void removeSelectedElements() {
        int[] indices = this.getSelectedIndices();
        Arrays.sort(indices);
        DefaultListModel model = (DefaultListModel)this.getModel();
        for (int i = indices.length; i > 0; --i) {
            model.removeElementAt(indices[i - 1]);
        }
    }

    public void setListData(List elements) {
        this.elements = elements;
        DefaultListModel model = (DefaultListModel)this.getModel();
        model.removeAllElements();
        this.addObjects(model);
    }

    public void setListData(Object[] elements) {
        this.setListData(Arrays.asList(elements));
    }

    public void setListData(Vector elements) {
        this.setListData((List)elements);
    }

    public void setModel(ListModel model) {
        if (!(model instanceof DefaultListModel)) {
            throw new ClassCastException("Model must be an instance of javax.swing.DefaultListModel");
        }
        super.setModel(model);
    }

    @Override
    public void setEditable(boolean editable) {
        this.setEnabled(editable);
    }

    @Override
    public void addInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.addListener(this.listener, listener);
    }

    @Override
    public void removeInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.removeListener(this.listener, listener);
    }

    public void fireInputField() {
        if (this.listener != null) {
            this.listener.inputFieldChanged(new InputFieldEvent(this));
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    private void initialize(List elements) {
        this.elements = elements;
        DefaultListModel model = new DefaultListModel();
        this.setModel((ListModel)model);
        this.addObjects(model);
        this.addEventHandler();
        InputListCellRenderer renderer = new InputListCellRenderer();
        this.setCellRenderer(renderer);
    }

    private void addObjects(DefaultListModel model) {
        int length = this.elements.size();
        for (int i = 0; i < length; ++i) {
            model.addElement(this.elements.get(i));
        }
    }

    private void addEventHandler() {
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                InputList.this.fireInputField();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    InputList.this.fireAction();
                }
            }
        });
    }

    private void fireAction() {
        if (this.actionListener != null) {
            ActionEvent e = new ActionEvent(this.getSelectedValue(), 1001, "list action");
            this.actionListener.actionPerformed(e);
        }
    }
}

