/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.template;

import ch.e2e.xuml.substitutor.PlaceholderSubsitutorFactory;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutor;
import ch.e2e.xuml.template.Template;
import ch.e2e.xuml.template.TemplateConstants;
import ch.e2e.xuml.template.TemplateProcessingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class FileTemplate
implements Template {
    private final File templateFile;
    private final File targetFile;

    public FileTemplate(File templateFile, File targetFile) {
        this.templateFile = templateFile;
        this.targetFile = targetFile;
    }

    @Override
    public String getName() {
        return this.templateFile.getName();
    }

    @Override
    public PlaceholderSubstitutor getPlaceholderSubstitutor() {
        return PlaceholderSubsitutorFactory.getDefaultSubstitutor();
    }

    @Override
    public File getTargetFile() {
        return this.targetFile;
    }

    @Override
    public Reader getReader() throws TemplateProcessingException {
        try {
            return new InputStreamReader((InputStream)new FileInputStream(this.templateFile), TemplateConstants.UTF_8_CHARSET);
        }
        catch (FileNotFoundException e) {
            throw new TemplateProcessingException(e);
        }
    }

    @Override
    public Writer getWriter() throws TemplateProcessingException {
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.getTargetFile()), TemplateConstants.UTF_8_CHARSET);
        }
        catch (FileNotFoundException e) {
            throw new TemplateProcessingException(e);
        }
    }
}

