/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.input;

import ch.e2e.ant.gui.configuration.ConfigurationTools;
import ch.e2e.ant.gui.configuration.types.AbstractGuiElement;
import ch.e2e.gui.InputField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.resource.Properties;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class InputElement
extends AbstractGuiElement
implements InputField {
    private String name;
    private InputFieldListener listener;
    private String enabledIf;
    private String enabledUnless;
    private String editableIf;
    private String editableUnless;
    private String displayName;
    private ActionListener actionListener;

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void addInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.addListener((InputFieldListener)this.listener, (InputFieldListener)listener);
    }

    public void removeInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.removeListener((InputFieldListener)this.listener, (InputFieldListener)listener);
    }

    public void setEditable(boolean editable) {
        this.setEnabled(editable);
    }

    public void setContent(Object content) {
    }

    public Object getContent() {
        return this.getValue();
    }

    public void fireInputFieldChanged(InputField source) {
        if (this.listener != null) {
            InputFieldEvent event = new InputFieldEvent(source);
            this.listener.inputFieldChanged(event);
        }
    }

    public abstract String getValue();

    public abstract boolean isEnabled();

    public abstract void requestFocus();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabledIf(String enabledIf) {
        this.enabledIf = enabledIf;
    }

    public void setEnabledUnless(String enabledUnless) {
        this.enabledUnless = enabledUnless;
    }

    public void setEditableIf(String editableIf) {
        this.editableIf = editableIf;
    }

    public void setEditableUnless(String editableUnless) {
        this.editableUnless = editableUnless;
    }

    public void setEnabled(Properties properties) {
        this.setEnabled(ConfigurationTools.checkIfUnless(this.enabledIf, this.enabledUnless, properties));
    }

    public void setEditable(Properties properties) {
        this.setEditable(ConfigurationTools.checkIfUnless(this.editableIf, this.editableUnless, properties));
    }

    public void setEnabled(boolean enabled) {
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(actionListener, this.actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(actionListener, this.actionListener);
    }

    public void fireAction(ActionEvent event) {
        if (this.actionListener != null) {
            event.setSource(this);
            this.actionListener.actionPerformed(event);
        }
    }
}

