/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration;

import ch.e2e.ant.gui.configuration.types.AntParam;
import ch.e2e.ant.gui.configuration.types.AntTarget;
import ch.e2e.util.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.input.InputHandler;

public class AntExecuter {
    private static InputHandler inputHandler;
    private Project project;
    private ArrayList<AntTarget> targets = new ArrayList();

    public AntExecuter(Project project, ArrayList<AntTarget> targets, BuildListener buildListener) {
        this.project = project;
        this.targets = targets;
        if (buildListener != null) {
            project.addBuildListener(buildListener);
        }
        if (inputHandler != null) {
            project.setInputHandler(inputHandler);
        }
    }

    public static void setInputHandler(InputHandler inputHandler) {
        AntExecuter.inputHandler = inputHandler;
    }

    public void execute() {
        int length = this.targets.size();
        for (int i = 0; i < length; ++i) {
            AntTarget antTarget = this.targets.get(i);
            String targetName = antTarget.getName();
            ArrayList<AntParam> params = antTarget.getParams();
            this.fillParameter(params);
            this.project.executeTarget(targetName);
        }
    }

    private void fillParameter(ArrayList<AntParam> params) {
        HashMap<String, String> parameter = new HashMap<String, String>();
        for (AntParam param : params) {
            if (!param.isUseable(this.project)) continue;
            String name = StringTools.replaceProperties((String)param.getName(), (Map)this.project.getProperties());
            String value = StringTools.replaceProperties((String)param.getValue(), (Map)this.project.getProperties());
            String property = (String)parameter.get(name);
            if (property == null) {
                parameter.put(name, value);
                continue;
            }
            parameter.put(name, property + ' ' + value);
        }
        for (String name : parameter.keySet()) {
            this.project.setProperty(name, (String)parameter.get(name));
        }
    }
}

