/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.plugin.project;

import ch.e2e.builder.base.plugin.project.DefaultProjectManager;
import ch.e2e.builder.base.plugin.project.PluginProjectEvent;
import ch.e2e.builder.base.plugin.project.PluginProjectEventListener;
import ch.e2e.builder.base.plugin.project.PluginProjectEventMulticaster;
import ch.e2e.builder.base.project.event.OpenUMLModelEvent;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import java.io.File;
import java.util.EventObject;
import java.util.List;

public abstract class PluginProjectManager {
    public static final String PLUGIN_PROJECT_MANAGER_KEY = "ch.e2e.builder.base.plugin.project.manager";
    private static PluginProjectManager projectManager;
    private PluginProjectEventListener listener;

    protected PluginProjectManager() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                PluginProjectManager.this.loadProject(((OpenUMLModelEvent)event).getModelFile(), false);
            }
        }, OpenUMLModelEvent.class);
    }

    public static PluginProjectManager getInstance() {
        if (projectManager == null) {
            PluginProjectManager.createProjectManager();
        }
        return projectManager;
    }

    public abstract List getProjects();

    public abstract void loadProject(File var1, boolean var2, boolean var3);

    public abstract void loadProject(File var1, boolean var2);

    public abstract void loadProject(String var1);

    public abstract Object getActiveProject();

    public abstract Object createProject(File var1);

    public abstract File getActiveProjectFile();

    public abstract File getActiveProjectDir();

    public abstract void setActiveProject(Object var1);

    public abstract void saveActiveProject();

    public abstract boolean saveProject(Object var1, File var2);

    public abstract void importFile(File var1, Object var2);

    public abstract void reloadModule(File var1, Object var2);

    public abstract void useModule(File var1, Object var2);

    public abstract void importModule(File var1, Object var2);

    public abstract void closeProject(Object var1);

    public abstract void closeProject(File var1, boolean var2);

    public void addPluginProjectEventListener(PluginProjectEventListener listener) {
        this.listener = PluginProjectEventMulticaster.addListener(this.listener, listener);
    }

    public void removeListener(PluginProjectEventListener listener) {
        this.listener = PluginProjectEventMulticaster.removeListener(this.listener, listener);
    }

    protected void fireProjectOpened(PluginProjectEvent event) {
        if (this.listener != null) {
            this.listener.projectOpened(event);
        }
    }

    protected void fireProjectClosed(PluginProjectEvent event) {
        if (this.listener != null) {
            this.listener.projectClosed(event);
        }
    }

    protected void fireProjectSaved(PluginProjectEvent event) {
        if (this.listener != null) {
            this.listener.projectSaved(event);
        }
    }

    protected void fireProjectActivated(PluginProjectEvent event) {
        if (this.listener != null) {
            this.listener.projectActivated(event);
        }
    }

    protected void fireProjectDeActivated(PluginProjectEvent event) {
        if (this.listener != null) {
            this.listener.projectDeActivated(event);
        }
    }

    protected void fireProjectReplaced(PluginProjectEvent event) {
        if (this.listener != null) {
            this.listener.projectReplaced(event);
        }
    }

    private static void createProjectManager() {
        try {
            String classname = System.getProperty(PLUGIN_PROJECT_MANAGER_KEY);
            Class<?> clazz = Class.forName(classname, true, PluginProjectManager.class.getClassLoader());
            projectManager = (PluginProjectManager)clazz.newInstance();
        }
        catch (Throwable e) {
            projectManager = new DefaultProjectManager();
        }
    }
}

