/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.test;

import ch.e2e.builder.compiler.build.test.Xmi2ExmiDifference;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.test.E2EComparisonController;
import ch.e2e.test.E2EDiff;
import ch.e2e.test.E2EDifferenceEngine;
import ch.e2e.test.E2ETest;
import ch.e2e.test.XMLCompare;
import ch.e2e.test.options.BooleanOption;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.ComparisonController;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Xmi2ExmiCompare
extends XMLCompare {
    private File sourceFolder;
    private File controlFolder;

    public void doTest(E2ETest test) throws IOException, ParserConfigurationException, SAXException {
        File[] controlFiles = FileUtilities.getFileList((File)this.controlFolder, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".bxmi");
            }
        }, (boolean)true);
        E2ETest.assertFalse((String)("No control files found in '" + this.controlFolder.getAbsolutePath() + "'."), (controlFiles.length == 0 ? 1 : 0) != 0);
        Xmi2ExmiDifference diff = new Xmi2ExmiDifference();
        for (File controlFile : controlFiles) {
            File testFile = new File(this.sourceFolder, FileUtilities.getRelativePath((File)controlFile, (File)this.controlFolder));
            this.compareFiles(testFile, controlFile, diff);
        }
        if (((Boolean)((BooleanOption)this.getOptions().get("xml.compare.type")).getValue()).booleanValue()) {
            E2ETest.assertTrue((String)diff.toString(), (boolean)diff.isIdentical());
        } else {
            E2ETest.assertFalse((String)diff.toString(), (boolean)diff.isIdentical());
        }
    }

    public void init(Element options) {
        NodeList controlFolders;
        super.init(options);
        NodeList sourceFolders = options.getElementsByTagName("source");
        if (sourceFolders != null && sourceFolders.getLength() == 1) {
            this.sourceFolder = new File(((Element)sourceFolders.item(0)).getAttribute("folder"));
        }
        if ((controlFolders = options.getElementsByTagName("control")) != null && controlFolders.getLength() == 1) {
            this.controlFolder = new File(((Element)controlFolders.item(0)).getAttribute("folder"));
        }
    }

    public void setGlobalTestOptions(Element options) {
        super.setGlobalTestOptions(options);
    }

    private void compareFiles(File testFile, File controlFile, Xmi2ExmiDifference diff) throws IOException, ParserConfigurationException, SAXException {
        Document referenceDocument = DomUtilities.parse((Reader)new FileReader(controlFile), (boolean)false, (boolean)false, (boolean)false);
        Document testDocument = DomUtilities.parse((Reader)new FileReader(testFile), (boolean)false, (boolean)false, (boolean)false);
        E2EComparisonController controller = new E2EComparisonController();
        E2EDiff xmlDiff = new E2EDiff(referenceDocument, testDocument, (DifferenceEngine)new E2EDifferenceEngine((ComparisonController)controller, this.getIgnoredAttributes(), this.getIgnoredElements()), controlFile.getName());
        diff.appendXMLDiff((Diff)xmlDiff);
    }
}

