/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.rest;

import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.addons.rest.service.Service;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceTabfile
extends XmlTabfile {
    private static final List<String> KNOWN_VARIABLES = new ArrayList<String>(){
        {
            this.add("addOn_SEI_HTTP_Service_MaximumConnections");
            this.add("addOn_SEI_HTTP_Service_ResolveHostnames");
            this.add("addOn_SOAP_AllowTracing");
        }
    };
    private Map<String, Service> services = new TreeMap<String, Service>();

    public ServiceTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    protected static Iterator<Element> getElementIteratorByXPath(Element tabfileElement, String xpath) {
        NodeList nodes = DomUtilities.EMPTY_NODE_LIST;
        try {
            nodes = (NodeList)DomUtilities.evaluate((Node)tabfileElement, (String)xpath, (QName)XPathConstants.NODESET);
            return nodes;
        }
        finally {
            return DomUtilities.elementIterator((NodeList)nodes);
        }
    }

    @Override
    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
        if (library) {
            for (Service service : this.services.values()) {
                service.nukeVariables(substitutions, this.getName());
            }
        }
        super.doMergePostProcess(substitutions, library);
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element replaced = (Element)this.doReplace(table, configurationElement, compilableObject);
        Iterator<Element> serviceIterator = ServiceTabfile.getElementIteratorByXPath(replaced, "Service");
        while (serviceIterator.hasNext()) {
            Service service = new Service(serviceIterator.next());
            if (this.services.containsKey(service.getName())) continue;
            this.services.put(service.getName(), service);
        }
        return true;
    }

    @Override
    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        if (!library.booleanValue()) {
            this.prepareDocument();
            super.beforeSerialize(zipOut, fileName, library);
        }
    }

    @Override
    public void serialize(OutputStream outputStream, boolean indent, boolean library) throws Exception {
        if (!library) {
            super.serialize(outputStream, indent, library);
        }
    }

    public void prepareDocument() {
        this.setTabfileDocument(null);
        Element root = this.getDocument().getDocumentElement();
        root.removeAttribute("xmlns:xmi");
        for (Service service : this.services.values()) {
            service.buildDom(root, false);
        }
    }
}

