/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.eml.EmlFactory;
import ch.e2e.builder.compiler.build.eml.EmlFunction;
import ch.e2e.builder.compiler.build.types.RuntimeFeature;
import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.XPathReplacer;
import ch.e2e.builder.compiler.build.types.substitutions.TemplatedFile;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlTabfile {
    public static final String EML_NAMESPACE_URI = "http://e2e.ch/bridge/macroLanguage";
    public static final String EMPTY_STRING = "";
    private Document tabfileDocument;
    private HashMap<Node, HashMap<String, String>> rows = new HashMap();
    private String rootElementName;
    private String name;
    private String filename;
    private HashMap<String, String> ids = new HashMap();
    private String originalName;
    private AbstractErrorHandler errorHandler;
    private Set<RuntimeFeature> runtimeFeatures = new TreeSet<RuntimeFeature>((lhs, rhs) -> rhs.versionCompare((RuntimeFeature)lhs));

    public XmlTabfile(String rootElementName, String name, String filename) {
        this.rootElementName = rootElementName;
        this.name = name;
        this.filename = filename;
    }

    public AbstractErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new AbstractErrorHandler(){};
        }
        return this.errorHandler;
    }

    public String getName() {
        return this.name;
    }

    public String getFilename() {
        return this.filename;
    }

    public Document getTabfileDocument() {
        return this.tabfileDocument;
    }

    protected void setTabfileDocument(Document tabfileDocument) {
        this.tabfileDocument = tabfileDocument;
    }

    public String getKey(boolean library) {
        return this.filename.length() == 0 ? this.name : this.filename;
    }

    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element parentNode = this.getDocument().getDocumentElement();
        return this.appendTable(table, parentNode, configurationElement, compilableObject);
    }

    protected boolean appendTable(Element table, Element parentNode, Element configurationElement, CompilableObject compilableObject) {
        boolean result = false;
        NodeList children = table.getChildNodes();
        if (children != null) {
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                if (child instanceof Element) {
                    result = true;
                    this.addRow(child, parentNode, configurationElement, compilableObject);
                    continue;
                }
                if (!(child instanceof Text)) continue;
                this.replaceText(child, configurationElement, compilableObject, parentNode);
            }
        }
        return result;
    }

    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
        TemplatedFile templatedFile = substitutions.getTemplates().get(this.getName());
        if (templatedFile != null) {
            templatedFile.setTarget(this.getFullName(library));
            templatedFile.setTemplate(this.getFullTemplateName(library));
        }
    }

    public String getExtension(boolean library) {
        return ".tab";
    }

    public String getFullName(boolean library) {
        return "tabfiles/" + this.getKey(library) + this.getExtension(library);
    }

    public String getFullTemplateName(boolean library) {
        return "templates/" + this.getKey(library) + this.getExtension(library);
    }

    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        zipOut.putNextEntry(new ZipEntry(fileName));
    }

    public void serialize(OutputStream outputStream, boolean indent, boolean library) throws Exception {
        DomUtilities.serialize((OutputStream)outputStream, (Document)this.tabfileDocument, (boolean)indent, (boolean)false);
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    protected void addRow(Node child, Node parent, Element configurationElement, CompilableObject compilableObject) {
        Node result;
        Node idAttribute = child.getAttributes().getNamedItem("id");
        if (!(idAttribute != null && this.ids.containsKey(((Attr)idAttribute).getValue()) || (result = this.doReplace(child, configurationElement, compilableObject)) == null)) {
            if (result instanceof Element) {
                this.addRow(result, parent, this.rows);
            } else if (result instanceof DocumentFragment) {
                this.appendChildren(result, parent, configurationElement, compilableObject);
            }
        }
    }

    protected final void addRow(Node tabfileEntry, Node parent, HashMap<Node, HashMap<String, String>> rows) {
        Node idAttribute = tabfileEntry.getAttributes().getNamedItem("id");
        if (idAttribute == null) {
            String row = this.createRowString(tabfileEntry);
            HashMap<String, String> list = rows.get(parent);
            if (list == null) {
                list = new HashMap();
                rows.put(parent, list);
            }
            if (row.length() > 0 && !list.containsKey(row)) {
                list.put(row, EMPTY_STRING);
                parent.appendChild(tabfileEntry);
            }
        } else if (!this.ids.containsKey(((Attr)idAttribute).getValue())) {
            this.ids.put(((Attr)idAttribute).getValue(), EMPTY_STRING);
            parent.appendChild(tabfileEntry);
        }
    }

    private String createRowString(Node child) {
        String nodeName = child.getNodeName();
        return "<" + nodeName + this.getAttributesString(child) + ">" + this.toString(child) + "</" + nodeName + ">";
    }

    protected Document getDocument() {
        if (this.tabfileDocument == null) {
            this.tabfileDocument = DomUtilities.newDocument((String)this.rootElementName);
            this.tabfileDocument.getDocumentElement().setAttribute("xmlns:xmi", "http://schema.omg.org/spec/XMI/2.1");
        }
        return this.tabfileDocument;
    }

    protected String getRootElementName() {
        return this.rootElementName;
    }

    private String toString(Node node) {
        StringBuilder row = new StringBuilder();
        NodeList children = node.getChildNodes();
        if (children != null) {
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                if (child instanceof Text) {
                    row.append(child.getNodeValue());
                    continue;
                }
                if (!(child instanceof Element)) continue;
                row.append('<').append(child.getNodeName()).append(this.getAttributesString(child)).append('>');
                row.append(this.toString(child)).append("</").append(child.getNodeName()).append('>');
            }
        }
        return row.toString();
    }

    protected final Node doReplace(Node element, Element configurationElement, CompilableObject compilableObject) {
        Node result;
        block8: {
            int i;
            int length;
            block7: {
                result = null;
                String namespaceURI = element.getNamespaceURI();
                if (namespaceURI == null || !namespaceURI.equals(EML_NAMESPACE_URI)) break block7;
                EmlFunction function = EmlFactory.getInstance().createEmlFunction(element);
                NodeList evaluatedNodes = function.evaluate(configurationElement, this);
                if (evaluatedNodes == null || evaluatedNodes.getLength() <= 0) break block8;
                result = this.getDocument().createDocumentFragment();
                int length2 = evaluatedNodes.getLength();
                for (int i2 = 0; i2 < length2; ++i2) {
                    Node node = evaluatedNodes.item(i2);
                    if (node instanceof Element) {
                        Node replacement = this.doReplace(node, configurationElement, compilableObject);
                        if (replacement == null) continue;
                        result.appendChild(replacement);
                        continue;
                    }
                    if (!(node instanceof Text)) continue;
                    this.replaceText(node, configurationElement, compilableObject, result);
                }
                break block8;
            }
            result = this.getDocument().createElement(element.getNodeName());
            if (element.hasAttributes()) {
                NamedNodeMap attributes = element.getAttributes();
                length = attributes.getLength();
                for (i = 0; i < length; ++i) {
                    Attr attribute = (Attr)attributes.item(i);
                    String value = (String)XPathReplacer.replaceText(attribute.getValue(), this.getDocument(), configurationElement, compilableObject, this.getErrorHandler());
                    String name = attribute.getName();
                    if (name.startsWith("xmlns")) continue;
                    ((Element)result).setAttribute(name, value);
                }
            }
            NodeList children = element.getChildNodes();
            length = children.getLength();
            for (i = 0; i < length; ++i) {
                Node node = children.item(i);
                if (node instanceof Element) {
                    Node child = this.doReplace(node, configurationElement, compilableObject);
                    if (child == null) continue;
                    if (child instanceof DocumentFragment) {
                        this.appendChildren(child, result, configurationElement, compilableObject);
                        continue;
                    }
                    result.appendChild(child);
                    continue;
                }
                if (!(node instanceof Text)) continue;
                this.replaceText(node, configurationElement, compilableObject, result);
            }
        }
        return result;
    }

    private void replaceText(Node node, Element configurationElement, CompilableObject compilableObject, Node result) {
        Node replacedText = this.replaceText(node.getNodeValue(), configurationElement, compilableObject);
        if (replacedText instanceof DocumentFragment) {
            this.appendChildren(replacedText, result, configurationElement, compilableObject);
        } else if (replacedText instanceof Element) {
            result.appendChild(this.doReplace(replacedText, configurationElement, compilableObject));
        } else {
            result.appendChild(replacedText);
        }
    }

    private void appendChildren(Node replacedText, Node result, Element configurationElement, CompilableObject compilableObject) {
        NodeList childNodes = replacedText.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node item = childNodes.item(i);
            if (item instanceof Element) {
                this.addRow(item, result, configurationElement, compilableObject);
                continue;
            }
            if (!(item instanceof Text)) continue;
            this.replaceText(item, configurationElement, compilableObject, result);
        }
    }

    private String getAttributesString(Node element) {
        StringBuilder attributesString = new StringBuilder(" ");
        if (element.hasAttributes()) {
            NamedNodeMap attributes = element.getAttributes();
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                attributesString.append(attribute.getName()).append("=\"").append(attribute.getValue()).append("\" ");
            }
        }
        return attributesString.toString();
    }

    private Node replaceText(String s, Element configurationElement, CompilableObject compilableObject) {
        Node result = null;
        int startIndex = s.indexOf("$REPLACE{");
        if (startIndex == -1) {
            result = this.getDocument().createTextNode(s);
        } else {
            StringBuilder replaceString = new StringBuilder();
            replaceString.append(s.substring(0, startIndex));
            boolean replaceTextData = true;
            while (startIndex > -1) {
                int endIndex = XPathReplacer.findClosingBreak(s, startIndex + 9);
                String s2 = s.substring(startIndex + 9, endIndex);
                Object xPathResult = XPathReplacer.replaceXPath(s2, this.getDocument(), configurationElement, compilableObject, this.getErrorHandler());
                if (xPathResult != null) {
                    if (xPathResult instanceof String && replaceTextData) {
                        String xPathStr = (String)xPathResult;
                        xPathStr = XPathReplacer.checkFunctions(xPathStr);
                        replaceString.append(xPathStr);
                    } else if (xPathResult instanceof DocumentFragment) {
                        replaceTextData = false;
                        result = (Node)xPathResult;
                    } else if (xPathResult instanceof String) {
                        Text text = this.getDocument().createTextNode(replaceString.toString());
                        result.appendChild(text);
                    }
                }
                if ((startIndex = s.indexOf("$REPLACE{", endIndex + 1)) == -1) {
                    replaceString.append(s.substring(endIndex + 1));
                    continue;
                }
                replaceString.append(s.substring(endIndex + 1, startIndex));
            }
            if (replaceTextData) {
                result = this.getDocument().createTextNode(replaceString.toString());
            }
        }
        return result;
    }

    public Set<RuntimeFeature> getRuntimeFeatures() {
        return this.runtimeFeatures;
    }

    public void addRuntimeFeature(String description, int runtimeVersionMajor, int runtimeVersionMinor, boolean isRuntimeVersionRequired) {
        this.runtimeFeatures.add(new RuntimeFeature(description, runtimeVersionMajor, runtimeVersionMinor, isRuntimeVersionRequired));
    }
}

