/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocumentationTabfile
extends XmlTabfile {
    public DocumentationTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    @Override
    public String getExtension(boolean library) {
        return library ? super.getExtension(library) : "";
    }

    @Override
    public String getFullName(boolean library) {
        return "documentation/" + this.getKey(library) + this.getExtension(library);
    }

    @Override
    public String getFullTemplateName(boolean library) {
        return "templates/" + this.getFullName(library);
    }

    @Override
    public void serialize(OutputStream outputStream, boolean indent, boolean library) throws Exception {
        if (!library) {
            PrintWriter writer = new PrintWriter(outputStream);
            if (this.getTabfileDocument() != null && this.getTabfileDocument().getDocumentElement() != null) {
                writer.print(this.getTabfileDocument().getDocumentElement().getTextContent());
            }
            writer.flush();
        } else {
            super.serialize(outputStream, indent, library);
        }
    }

    @Override
    public String getKey(boolean library) {
        return library ? this.getName() : super.getKey(library);
    }

    @Override
    protected Document getDocument() {
        Document result;
        if (this.getTabfileDocument() == null) {
            result = DomUtilities.newDocument((String)"Documentation");
            result.getDocumentElement().setAttribute("multiTabfileDocument", "true");
            result.getDocumentElement().setAttribute("rootElementName", this.getRootElementName());
            this.setTabfileDocument(result);
        } else {
            result = this.getTabfileDocument();
        }
        return result;
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element parentNode = this.getDocument().createElement(table.getNodeName());
        parentNode.setAttribute("filename", table.getAttribute("filename"));
        this.getDocument().getDocumentElement().appendChild(parentNode);
        parentNode.setTextContent(table.getTextContent());
        return true;
    }
}

