/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.BridgeInstance;
import ch.e2e.builder.compiler.build.types.LogStreams;
import ch.e2e.event.EventController;
import ch.e2e.io.ProcessExecuter;
import ch.e2e.io.ProcessStoppedEvent;
import ch.e2e.io.ProcessStoppedListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

public class BridgeInstanceProcess
implements ProcessStoppedListener {
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private BridgeInstance instance;
    private LogStreams logStreams;
    private ProcessExecuter startProcess;
    private ProcessExecuter killProcess;
    private ProcessStoppedListener stopListener;
    private OutputStream startupLog;

    public BridgeInstanceProcess(BridgeInstance instance, LogStreams logStreams) throws FileNotFoundException {
        this.instance = instance;
        this.logStreams = logStreams;
        this.startProcess = new ProcessExecuter();
        this.startProcess.setSystemErr(logStreams.getErrorOut());
        this.startProcess.addProcessStoppedListener((ProcessStoppedListener)this);
        this.killProcess = new ProcessExecuter();
        this.killProcess.setSystemErr(logStreams.getErrorOut());
    }

    public void setInstance(BridgeInstance instance) {
        this.instance = instance;
    }

    public BridgeInstance getBridgeInstance() {
        return this.instance;
    }

    public boolean isRunning() {
        return this.startProcess.isRunning();
    }

    public void start() {
        try {
            this.openStartupLog();
            this.instance.setStopped(false);
            this.instance.checkRuntimeIsExecutable();
            this.startProcess.execute(this.instance.getStartFile().getFile().getAbsolutePath());
            this.startupLog.flush();
        }
        catch (Exception e) {
            e.printStackTrace(new PrintStream(this.logStreams.getErrorOut()));
            this.instance.getDeployment().setStatus(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ProcessStoppedListener stopListener) {
        this.stopListener = stopListener;
        try (Client client = null;){
            client = ClientBuilder.newBuilder().build();
            URI uri = new URI("http://localhost:" + this.getBridgeInstance().getControlPort() + "/api/stop");
            WebTarget target = client.target(uri);
            Invocation invocation = target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPut(Entity.json((Object)"{}"));
            invocation.invoke();
        }
    }

    public void kill() {
        try {
            this.killProcess.executeAndWait(this.instance.getKillFile().getFile().getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace(new PrintStream(this.logStreams.getErrorOut()));
            this.instance.getDeployment().setStatus(5);
            this.closeStartupLog();
        }
    }

    public void removeStopListener() {
        this.stopListener = null;
    }

    public void processStopped(ProcessStoppedEvent event) {
        EventController.fire((EventObject)event);
        this.instance.getDeployment().setStatus(5);
        this.instance.setStopped(true);
        if (this.stopListener != null) {
            this.stopListener.processStopped(event);
        }
        this.closeStartupLog();
    }

    private void closeStartupLog() {
        try {
            this.startupLog.flush();
            this.startupLog.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void openStartupLog() throws FileNotFoundException {
        File logFolder = new File(this.instance.getInstanceHome(), "logs");
        if (!logFolder.exists()) {
            logFolder.mkdirs();
        }
        File logfile = new File(logFolder, "startup_" + dateFormatter.format(new Date()) + ".log");
        this.startupLog = new PrintStream(new Logfile(logfile));
        this.startProcess.setSystemOut(this.startupLog);
    }

    private class Logfile
    extends FileOutputStream {
        public Logfile(File file) throws FileNotFoundException {
            super(file, true);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            this.flush();
        }
    }
}

