/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular.clean;

import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.clean.AngularCleanWorkspaceTask;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.project.AngularLibSourcesTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.form.FormHelper;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.json.xuml.form.XumlForm;
import ch.e2e.builder.compiler.document.json.xuml.usages.XumlClassesUsages;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class AngularFormInterfaceProjectCleanTask
extends AngularCleanWorkspaceTask {
    public static Boolean select(String id) {
        return id.endsWith("angular-lib/form.interface.clean");
    }

    public AngularFormInterfaceProjectCleanTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add("dataModel/dataModel.classes.usages.xml");
        result.addAll(FormHelper.getFormJsonDocumentSourceSet(this.getSourceManager()));
        return result;
    }

    @Override
    protected Set<String> getOutdatedFiles() throws Exception {
        File libFolder = new File(this.getSourceManager().getWorkFolder(), Folders.angularLib_projects_PROJECT__src_lib(this.getAngularProjectName()));
        if (libFolder.exists()) {
            XSLTTransformSource classesUsagesSource = (XSLTTransformSource)this.getSourceManager().getSource("dataModel/dataModel.classes.usages.xml");
            XumlClassesUsages classesUsages = XSLTTransformSource.getJsonDocument(classesUsagesSource, XumlClassesUsages.class);
            HashSet upToDateInterfaces = new HashSet();
            FormHelper.getXumlForms(this.getSourceManager()).stream().filter(XumlForm::getLibraryExposed).forEach(form -> AngularLibSourcesTask.addFormInterfaceSources(upToDateInterfaces, this.getAngularProjectName(), form, classesUsages));
            HashSet<String> result = new HashSet<String>();
            Files.walk(libFolder.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(file -> file.isFile() && file.getName().endsWith(".interface.ts")).map(file -> this.getSourceManager().getWorkFolder().toPath().relativize(file.toPath()).toString()).filter(interfaceId -> upToDateInterfaces.stream().noneMatch(id -> id.equals(interfaceId))).forEach(interfaceId -> result.addAll(this.interfaceFileGroup((String)interfaceId)));
            return result;
        }
        return new HashSet<String>();
    }

    private Set<String> interfaceFileGroup(final String id) {
        return new HashSet<String>(){
            {
                this.add(id);
                this.add(id + ".hash");
                this.add(id + ".xml");
                this.add(id + ".xml" + ".hash");
                this.add(id + ".xml" + ".sources");
            }
        };
    }
}

