/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular;

import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.builder.compiler.utils.StringUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AngularHelper {
    public static final String SOURCE_TEMPLATE_ANGULAR = CompilerConstants.SOURCE_TEMPLATE_RESOURCE_BASE_PATH + "angular/";
    public static final String PROJECT_NAME_PATH_PLACEHOLDER = "__PROJECT_NAME__";
    public static final String INTERMEDIATE_NAME_PATH_PLACEHOLDER = "__INTERMEDIATE_NAME__";
    public static final String MODULE_NAME_PATH_PLACEHOLDER = "__MODULE_NAME__";
    public static final String PROCESS_NAME_PATH_PLACEHOLDER = "__PROCESS_NAME__";
    public static final String TASK_NAME_PATH_PLACEHOLDER = "__TASK_NAME__";
    public static final String NAME_DELIMITER = "-";
    public static final String LIBRARY_PROJECT_SUFFIX = "-library";
    public static final String MAIN_PROJECT_SUFFIX = "-main";
    public static final String FORM_PROJECT_SUFFIX = "-form";
    public static final String PROCESS_PROJECT_SUFFIX = "-process";
    public static final String TASK_PROJECT_SUFFIX = "-task";
    private static final Pattern DIST_PATTERN = Pattern.compile(Folders.angular_dist_PROJECT(AngularHelper.getMainProjectName("(.*)")) + ".zip");
    private static final Pattern TASKS_PATTERN = Pattern.compile(Folders.angular_projects_PROJECT_src_app_process_PROCESS_tasks_TASK(AngularHelper.getMainProjectName("(.*)"), "(.*)", "(.*)"));
    private static final Pattern PROCESS_PATTERN = Pattern.compile(Folders.angular_projects_PROJECT_src_app_process_PROCESS(AngularHelper.getMainProjectName("(.*)"), "(.*)"));
    private static final Pattern LIB_PROJECT_PATTERN = Pattern.compile(Folders.angularLib_projects_PROJECT_("(.*)") + "(.*)");

    private static String getAngularProjecName(String projectName) {
        return projectName.replaceAll("[- ]{1}", "_");
    }

    public static String getAngularLibName(String projectName) {
        return AngularHelper.convert2KebabCase(projectName.replaceAll("[ ]{1}", NAME_DELIMITER));
    }

    public static String getAngularLibArchiveName(XumlProject project) {
        return AngularHelper.getAngularLibName(project.getName()) + NAME_DELIMITER + project.getVersion() + ".tgz";
    }

    public static String getLibraryProjectName(String projectName) {
        return AngularHelper.getAngularProjecName(projectName) + LIBRARY_PROJECT_SUFFIX;
    }

    public static String getMainProjectName(String projectName) {
        return AngularHelper.getAngularProjecName(projectName) + MAIN_PROJECT_SUFFIX;
    }

    public static String getFormProjectName(String projectName, String formName) {
        return AngularHelper.getAngularProjecName(projectName) + NAME_DELIMITER + AngularHelper.getAngularProjecName(formName) + FORM_PROJECT_SUFFIX;
    }

    public static String getProcessProjectName(String projectName, String formName) {
        return AngularHelper.getAngularProjecName(projectName) + NAME_DELIMITER + AngularHelper.getAngularProjecName(formName) + PROCESS_PROJECT_SUFFIX;
    }

    public static String getTaskProjectName(String projectName, String processName, String taskName) {
        return AngularHelper.getAngularProjecName(projectName) + NAME_DELIMITER + AngularHelper.getAngularProjecName(processName) + NAME_DELIMITER + AngularHelper.getAngularProjecName(taskName) + TASK_PROJECT_SUFFIX;
    }

    public static String extractAngularProjectName(String id) {
        return StringUtils.substringBetween(id, "angular/projects/", "/");
    }

    public static String extractProjectName(String angularProjectName) {
        String[] names = angularProjectName.split(NAME_DELIMITER);
        if (names.length > 1) {
            return names[0];
        }
        return "";
    }

    public static String extractIntermediateName(String angularProjectName) {
        String[] names = angularProjectName.split(NAME_DELIMITER);
        if (names.length > 3) {
            return names[1];
        }
        return "";
    }

    public static String extractModuleName(String angularProjectName) {
        String[] names = angularProjectName.split(NAME_DELIMITER);
        if (names.length == 3) {
            return names[1];
        }
        if (names.length > 3) {
            return names[2];
        }
        return "";
    }

    public static String getBaseResourceId(String id) {
        String path;
        Matcher distMatcher = DIST_PATTERN.matcher(id);
        Matcher tasksMatcher = TASKS_PATTERN.matcher(id);
        Matcher processMatcher = PROCESS_PATTERN.matcher(id);
        Matcher libraryProjectMatcher = LIB_PROJECT_PATTERN.matcher(id);
        if (distMatcher.matches()) {
            path = id.replaceFirst(distMatcher.group(1), PROJECT_NAME_PATH_PLACEHOLDER);
        } else if (libraryProjectMatcher.matches()) {
            path = id.replaceFirst(libraryProjectMatcher.group(1), PROJECT_NAME_PATH_PLACEHOLDER);
        } else if (tasksMatcher.matches()) {
            path = id.replaceFirst(tasksMatcher.group(1), PROJECT_NAME_PATH_PLACEHOLDER).replaceFirst(tasksMatcher.group(2), PROCESS_NAME_PATH_PLACEHOLDER).replaceFirst(StringUtils.substringBefore(tasksMatcher.group(3), "/"), TASK_NAME_PATH_PLACEHOLDER);
        } else if (processMatcher.matches()) {
            path = id.replaceFirst(processMatcher.group(1), PROJECT_NAME_PATH_PLACEHOLDER).replaceFirst(StringUtils.substringBefore(processMatcher.group(2), "/"), PROCESS_NAME_PATH_PLACEHOLDER);
        } else {
            String angularProjectName = AngularHelper.extractAngularProjectName(id);
            String projectName = AngularHelper.extractProjectName(angularProjectName);
            String intermediateName = AngularHelper.extractIntermediateName(angularProjectName);
            String moduleName = AngularHelper.extractModuleName(angularProjectName);
            path = AngularHelper.replaceProjectNameInPath(id, projectName, intermediateName, moduleName);
        }
        return CompilerConstants.SOURCE_TEMPLATE_RESOURCE_BASE_PATH + path;
    }

    private static String replaceProjectNameInPath(String path, String projectName, String intermediateName, String moduleName) {
        if (!projectName.equals("")) {
            path = path.replaceAll("/" + projectName, "/__PROJECT_NAME__");
            if (!intermediateName.equals("")) {
                path = path.replaceAll("/__PROJECT_NAME__-" + intermediateName, "/__PROJECT_NAME__-__INTERMEDIATE_NAME__");
                if (!moduleName.equals("")) {
                    path = path.replaceAll("/__PROJECT_NAME__-__INTERMEDIATE_NAME__-" + moduleName, "/__PROJECT_NAME__-__INTERMEDIATE_NAME__-__MODULE_NAME__");
                }
            } else if (!moduleName.equals("")) {
                path = path.replaceAll("/__PROJECT_NAME__-" + moduleName, "/__PROJECT_NAME__-__MODULE_NAME__");
            }
        }
        return path;
    }

    public static String extractAngularLibProjectName(String id) {
        return StringUtils.substringBetween(id, "angular-lib/projects/", "/");
    }

    public static String convert2KebabCase(String input) {
        Matcher matcher = Pattern.compile("[A-Z]{2,}(?=[A-Z][a-z]+[0-9]*|\\b)|[A-Z]?[a-z]+[0-9]*|[A-Z]|[0-9]+").matcher(input);
        ArrayList<String> matched = new ArrayList<String>();
        while (matcher.find()) {
            matched.add(matcher.group(0));
        }
        return matched.stream().map(String::toLowerCase).collect(Collectors.joining(NAME_DELIMITER));
    }
}

