/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.control;

import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.tasks.control.TaskInfo;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AggregateCompileControl
extends CompileControl {
    private final List<CompileControl> controls;

    public AggregateCompileControl(List<CompileControl> controls) {
        this.controls = controls.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void onTaskRequested(TaskInfo taskInfo, Integer dependencyLevel) {
        this.controls.forEach(control -> control.onTaskRequested(taskInfo, dependencyLevel));
    }

    @Override
    public void onTaskAlreadyExecuted(TaskInfo taskInfo, Integer dependencyLevel) {
        this.controls.forEach(control -> control.onTaskAlreadyExecuted(taskInfo, dependencyLevel));
    }

    @Override
    public void onTaskUpToDate(TaskInfo taskInfo, Integer dependencyLevel) {
        this.controls.forEach(control -> control.onTaskUpToDate(taskInfo, dependencyLevel));
    }

    @Override
    public void onTaskBeforeExecute(TaskInfo taskInfo, Integer dependencyLevel) {
        this.controls.forEach(control -> control.onTaskBeforeExecute(taskInfo, dependencyLevel));
    }

    @Override
    public void onTaskException(TaskInfo taskInfo, Integer dependencyLevel) {
        this.controls.forEach(control -> control.onTaskException(taskInfo, dependencyLevel));
    }

    @Override
    public void onTaskAfterExecute(TaskInfo taskInfo, Integer dependencyLevel) {
        this.controls.forEach(control -> control.onTaskAfterExecute(taskInfo, dependencyLevel));
    }

    @Override
    public boolean shouldAbortTask(TaskInfo taskInfo, Integer dependencyLevel) {
        return this.controls.stream().anyMatch(control -> control.shouldAbortTask(taskInfo, dependencyLevel));
    }

    @Override
    public void onTaskAbort(TaskInfo taskInfo, Integer dependencyLevel) {
        this.controls.forEach(control -> control.onTaskAbort(taskInfo, dependencyLevel));
    }
}

