/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tree;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AdapterOutput;
import ch.e2e.builder.trace.testcase.AdapterOutputContainer;
import ch.e2e.builder.trace.testcase.AdapterOutputContainerList;
import ch.e2e.builder.trace.testcase.uml.Activity;
import ch.e2e.builder.trace.testcase.uml.Adapter;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.DataContainer;
import ch.e2e.builder.trace.testcase.uml.Flow;
import ch.e2e.builder.trace.testcase.uml.RootObject;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectVisitor;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.builder.trace.tree.EditPreferencesExecuter;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.ZipUtilities;
import ch.e2e.logging.LogManager;
import java.io.File;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MockBackendsExecuter
extends EditPreferencesExecuter {
    public static final Logger logger = LogManager.getLogger((String)MockBackendsExecuter.class.getPackage().getName());

    public MockBackendsExecuter(E2EBuilderModule module, boolean showTraceProperties) {
        super(module, showTraceProperties);
    }

    @Override
    public void editPreferences(AbstractSynchronousTestcase testcase) {
        this.getPreferences().editPreferences(testcase, new AdapterOutputContainerList(testcase), null);
    }

    public void editPreferences(AbstractSynchronousTestcase testcase, Adapter adapter) {
        this.getPreferences().editPreferences(testcase, new AdapterOutputContainerList(testcase), adapter);
    }

    public void loadMockBackends(AbstractSynchronousTestcase testcase) {
        boolean treeLoaded;
        boolean bl = treeLoaded = testcase.getUmlTree() != null;
        if (!treeLoaded) {
            treeLoaded = testcase.loadUmlTreeFromDisk();
        }
        if (treeLoaded) {
            AdapterVisitor visitor = new AdapterVisitor(testcase);
            visitor.visit(testcase.getUmlTree());
            this.getPreferences().editPreferences(testcase, visitor.adapterOutputContainers, null);
        }
    }

    public static class AdapterVisitor
    extends UmlObjectVisitor {
        private final AbstractSynchronousTestcase testcase;
        private final AdapterOutputContainerList adapterOutputContainers;

        public AdapterVisitor(AbstractSynchronousTestcase testcase) {
            this.testcase = testcase;
            this.adapterOutputContainers = new AdapterOutputContainerList(testcase, false);
        }

        public void visit(UmlTree tree) {
            this.visitChilds((UmlObject)tree);
        }

        public void visit(UmlObject node) {
            this.visitChilds(node);
        }

        public void visit(RootObject root) {
            this.visitChilds((UmlObject)root);
        }

        public void visit(Flow flow) {
            this.visitChilds((UmlObject)flow);
        }

        public void visit(Activity activity) {
            this.visitChilds((UmlObject)activity);
        }

        public void visit(Adapter adapter) {
            int childCount;
            DataContainer output;
            AdapterOutputContainer adapterOutputContainer = this.getAdapterOutputContainer(adapter.getOriginalName());
            if (adapterOutputContainer != null && (output = adapter.getOutput()) != null && (childCount = output.getChildCount()) > 0) {
                Document document = DomUtilities.newDocument((String)"AdapterOutput");
                for (int i = 0; i < childCount; ++i) {
                    Data data = (Data)output.getChild(i);
                    try {
                        Document valueDocument = ZipUtilities.getZippedDocumentFromFile((File)this.testcase.getIOFile(), (String)data.getValue());
                        Element valueElement = (Element)valueDocument.getDocumentElement().getFirstChild();
                        document.getDocumentElement().appendChild(document.adoptNode(valueElement));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                AdapterOutput adapterOutput = new AdapterOutput(document.getDocumentElement(), true, adapterOutputContainer.getAdapterTemplate());
                adapterOutputContainer.addAdapterOutput(adapterOutput);
            }
        }

        private AdapterOutputContainer getAdapterOutputContainer(String id) {
            for (AdapterOutputContainer container : this.adapterOutputContainers) {
                if (!container.getId().equals(id)) continue;
                return container;
            }
            return null;
        }
    }
}

