/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tree;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractTestcaseFolder;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.tree.RefreshSynchronousTreeEvent;
import ch.e2e.builder.trace.tree.TestcaseExecuter;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;

public class CopyTestcaseExecuter
extends TestcaseExecuter {
    public CopyTestcaseExecuter(String pattern, E2EBuilderModule traceViewer) {
        super("copy", pattern, traceViewer);
    }

    public void copyTestcase(AbstractSynchronousTestcase testcase) {
        this.execute(testcase);
    }

    public void copyTestcase(AbstractSynchronousTestcase testcase, AbstractTestcaseFolder folder) {
        testcase.saveRequest();
        if (folder == null) {
            this.execute(testcase);
        } else {
            this.execute(testcase, folder);
        }
    }

    @Override
    protected void execute(String name, AbstractSynchronousTestcase testcase) throws IOException {
        this.execute(name, testcase, (AbstractTestcaseFolder)testcase.getParent());
    }

    @Override
    protected void execute(String name, AbstractSynchronousTestcase testcase, AbstractTestcaseFolder testcaseFolder) throws IOException {
        File adapterOutputsFile;
        FileUtilities.copyFile((File)testcase.getRequestFile(), (File)new File(testcaseFolder.getHome(), name + ".request"));
        FileUtilities.copyFile((File)new File(testcase.getHome(), testcase.getName() + ".testcase"), (File)new File(testcaseFolder.getHome(), name + ".testcase"));
        File httpHeadersFile = testcase.getHttpHeaders().getPropertiesFile();
        if (httpHeadersFile != null && httpHeadersFile.exists()) {
            FileUtilities.copyFile((File)httpHeadersFile, (File)new File(testcaseFolder.getHome(), name + ".httpheader"));
        }
        if ((adapterOutputsFile = testcase.getAdapterOutputsFile()).exists()) {
            FileUtilities.copyFile((File)adapterOutputsFile, (File)new File(testcaseFolder.getHome(), name + ".adapters"));
        }
        AbstractSynchronousTestcase copiedTestcase = testcaseFolder.createNewTestcase(name);
        copiedTestcase.clearResult();
        copiedTestcase.saveProperties();
        testcaseFolder.add((TestcaseObject)copiedTestcase);
        EventController.fire((EventObject)new RefreshSynchronousTreeEvent(this, (TestcaseObject)copiedTestcase));
    }
}

