/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.state;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlEdge;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.testcase.uml.Activity;
import ch.e2e.builder.trace.testcase.uml.Branches;
import ch.e2e.builder.trace.testcase.uml.Event;
import ch.e2e.builder.trace.testcase.uml.GenericFlow;
import ch.e2e.builder.trace.testcase.uml.Script;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventController;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import java.util.Map;

public class TransitionEdge
extends UmlEdge
implements CellWithContextMenu {
    private static TransitionContextMenu contextMenu;
    private String label;
    private GenericFlow flow;
    private Event event;
    private Script script;

    public TransitionEdge(Object userObject, GenericFlow flow, Event event, Branches branches, E2EBuilderModule module) {
        super(userObject, module);
        this.flow = flow;
        this.event = event;
        Script script = this.script = branches == null ? null : branches.getFollowedBranch();
        if (!(userObject instanceof Activity)) {
            this.label = super.toString();
        }
        String string = this.label = this.label != null && this.label.length() > 0 ? "/" + this.label : "";
        if (event != null && event.getUmlLabel() != null) {
            this.label = event.getUmlLabel() + this.label;
        }
        if (userObject instanceof UmlObject) {
            if (((UmlObject)userObject).hasErrors()) {
                UmlGraphConstants.setForeground((Map)this.attributes, (Color)UmlGraphConstants.ERROR_COLOR);
                UmlGraphConstants.setLineColor((Map)this.attributes, (Color)UmlGraphConstants.ERROR_COLOR);
            }
            UmlGraphConstants.setSelectable((Map)this.attributes, (boolean)true);
        }
        UmlGraphConstants.setLineEnd((Map)this.attributes, (int)4);
    }

    @Override
    public String toString() {
        return this.label;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public TransitionContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new TransitionContextMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    @Override
    public AbstractCellAction<? extends CellWithContextMenu> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return false;
    }

    private static class TransitionContextMenu
    extends ContextMenu<TransitionEdge> {
        public TransitionContextMenu(TransitionEdge cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(TransitionEdge cell) {
            super.setCell(cell);
            if (cell.flow != null) {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.activity"));
            } else if (cell.event != null && cell.event.getScriptId() != null || cell.script != null) {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.action.script"));
            } else {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.in.tree"));
            }
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.activity"), cell.flow != null);
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.action.script"), cell.event != null && cell.event.getScriptId() != null || cell.script != null);
        }

        private void createMenu() {
            this.addDefaultItem(new AbstractCellAction<TransitionEdge>(this.getTranslation("uml.diagram.action.show.in.tree")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = ((TransitionEdge)this.getCell()).getUserObject();
                    if (o instanceof UmlObject) {
                        EventController.fire((EventObject)new SelectInTreeEvent(this.getCell(), (UmlObject)o));
                    }
                }
            }, ACCELERATOR_SHOW_IN_TREE);
            this.addItem(new AbstractCellAction<TransitionEdge>(this.getTranslation("uml.diagram.action.show.activity")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericFlow flow = ((TransitionEdge)this.getCell()).flow;
                    if (flow != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this.getCell(), "file:///openActivity?activity=" + flow.getOriginalName()));
                    }
                }
            });
            this.addItem(new AbstractCellAction<TransitionEdge>(this.getTranslation("uml.diagram.action.show.action.script")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String scriptId;
                    Object object = ((TransitionEdge)this.getCell()).script == null ? (((TransitionEdge)this.getCell()).event == null ? null : ((TransitionEdge)this.getCell()).event.getScriptId()) : (scriptId = ((TransitionEdge)this.getCell()).script.getIoId());
                    if (scriptId != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this.getCell(), "file:///showScript?script=" + scriptId));
                    }
                }
            });
        }
    }
}

