/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.trace.gui.uml.UmlVertexView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

public class FinalNodeView
extends UmlVertexView {
    private static final FinalNodeRenderer RENDERER = new FinalNodeRenderer();

    public FinalNodeView() {
    }

    public FinalNodeView(Object cell) {
        super(cell);
    }

    @Override
    public CellViewRenderer getRenderer() {
        return RENDERER;
    }

    @Override
    public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
        return this.getRenderer() instanceof FinalNodeRenderer ? ((FinalNodeRenderer)this.getRenderer()).getPerimeterPoint(this, source, p) : super.getPerimeterPoint(edge, source, p);
    }

    protected static class FinalNodeRenderer
    extends VertexRenderer {
        protected FinalNodeRenderer() {
        }

        public void paint(Graphics g) {
            Color color = g.getColor();
            g.setColor(this.getBackground());
            g.fillArc(4, 4, this.getWidth() - 8, this.getHeight() - 8, 0, 360);
            g.drawArc(0, 0, this.getWidth() - 1, this.getHeight() - 1, 0, 360);
            g.setColor(color);
        }

        public Point2D getPerimeterPoint(VertexView view, Point2D source, Point2D p) {
            Rectangle2D bounds = view.getBounds();
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            double xCenter = bounds.getX() + width / 2.0;
            double yCenter = bounds.getY() + height / 2.0;
            double dx = p.getX() - xCenter;
            double dy = p.getY() - yCenter;
            double angle = Math.atan2(dy, dx);
            double xOut = xCenter + width / 2.0 * Math.cos(angle);
            double yOut = yCenter + height / 2.0 * Math.sin(angle);
            return new Point2D.Double(xOut, yOut);
        }
    }
}

