/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.Constants;
import ch.e2e.event.EventController;
import ch.e2e.gui.event.ValueChangedEvent;
import ch.e2e.gui.event.ValueChangedListener;
import ch.e2e.swing.ListStatusBarItem;
import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.status.StatusBar;
import com.jidesoft.swing.JideToggleButton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.apache.commons.codec.binary.Base64;
import org.fife.ui.hex.swing.HexEditor;

public class BlobViewerDialog
extends E2EBuilderDialog {
    private static final String DIALOG_TITLE = "blob.viewer.title";
    private static final Map<String, BlobViewerDialog> INSTANCES = new HashMap<String, BlobViewerDialog>();
    private static final String HEX_VIEWER = "hexViewer";
    private static final String BASE64_VIEWER = "base64Viewer";
    private static final String TEXT_VIEWER = "textViewer";
    private static final int CHUNK_SIZE = 10000;
    private static final int NEWLINE_LIMIT = 10000;
    private final E2EBuilderModule module;
    private Charset charset = Charset.defaultCharset();
    private byte[] blob;
    private CardLayout cards;
    private JPanel viewerPanel;
    private HexEditor hexViewer;
    private JTextArea base64Viewer;
    private JTextArea textViewer;
    private boolean updateHexViewer;
    private boolean updateBase64Viewer;
    private boolean updateTextViewer;
    private final SetBlobTransaction transaction;
    private Boolean newlineLimitExceeded = null;

    private BlobViewerDialog(E2EBuilderModule module) {
        super(module.getTranslation(DIALOG_TITLE, "Blob Viewer"), null, null, 0);
        this.module = module;
        this.createGui();
        this.transaction = new SetBlobTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlobViewerDialog getDialog(E2EBuilderModule module) {
        String key = module.getName();
        BlobViewerDialog instance = INSTANCES.get(key);
        if (instance == null) {
            Map<String, BlobViewerDialog> map = INSTANCES;
            synchronized (map) {
                instance = INSTANCES.get(key);
                if (instance == null) {
                    instance = new BlobViewerDialog(module);
                    INSTANCES.put(key, instance);
                }
            }
        }
        return instance;
    }

    public int show(byte[] blob) {
        EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)this.transaction, (Object)blob));
        return this.showDialog();
    }

    private void setBlob(byte[] blob) {
        this.blob = blob;
        this.updateTextViewer = true;
        this.updateBase64Viewer = true;
        this.updateHexViewer = true;
        this.newlineLimitExceeded = null;
        if (this.hexViewer.isVisible()) {
            this.setHex();
        }
        if (this.base64Viewer != null && this.base64Viewer.isVisible()) {
            this.setBase64();
        }
        if (this.textViewer != null && this.textViewer.isVisible()) {
            this.setText();
        }
    }

    private void setHex() {
        if (this.updateHexViewer) {
            this.updateHexViewer = false;
            try {
                this.getHexViewer().open((InputStream)new ByteArrayInputStream(this.blob == null ? new byte[]{} : this.blob));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setBase64() {
        if (this.updateBase64Viewer) {
            this.updateBase64Viewer = false;
            this.getBase64Viewer().setText(this.blob == null ? null : new String(Base64.encodeBase64Chunked((byte[])this.blob), Charset.forName("ascii")));
        }
    }

    private void setText() {
        if (this.updateTextViewer) {
            this.updateTextViewer = false;
            this.getTextViewer().setText(this.blob == null ? null : new String(this.blob, this.charset));
        }
    }

    public int getMinimumHeight() {
        return 250;
    }

    public int getMinimumWidth() {
        return 400;
    }

    private HexEditor getHexViewer() {
        return this.hexViewer;
    }

    private JTextArea getBase64Viewer() {
        if (this.base64Viewer == null) {
            this.base64Viewer = new JTextArea();
            this.base64Viewer.setEditable(false);
            this.viewerPanel.add((Component)new JScrollPane(this.base64Viewer), BASE64_VIEWER);
        }
        return this.base64Viewer;
    }

    private JTextArea getTextViewer() {
        if (this.textViewer == null) {
            this.textViewer = new JTextArea();
            this.textViewer.setEditable(false);
            this.viewerPanel.add((Component)new JScrollPane(this.textViewer), TEXT_VIEWER);
        }
        return this.textViewer;
    }

    private void createGui() {
        this.setTitlePanelVisible(false);
        this.setLayout(new BorderLayout());
        this.createToolBar();
        this.createViewers();
        this.createStatusBar(this.module);
    }

    private void createViewers() {
        this.cards = new CardLayout();
        this.viewerPanel = new JPanel(this.cards);
        this.add(this.viewerPanel, "Center");
        this.hexViewer = new HexEditor(false);
        this.hexViewer.setEditable(false);
        this.hexViewer.setShowColumnHeader(false);
        this.hexViewer.setShowRowHeader(false);
        this.viewerPanel.add((Component)this.hexViewer, HEX_VIEWER);
    }

    private void createToolBar() {
        JToolBar toolBar = new JToolBar();
        this.add(toolBar, "First");
        toolBar.setFloatable(false);
        ButtonGroup buttons = new ButtonGroup();
        JideToggleButton hexButton = this.createToggleButton(new SwitchToHex());
        buttons.add((AbstractButton)hexButton);
        hexButton.setSelected(true);
        toolBar.add((Component)hexButton);
        JideToggleButton base64Button = this.createToggleButton(new SwitchToBase64());
        buttons.add((AbstractButton)base64Button);
        toolBar.add((Component)base64Button);
        JideToggleButton textButton = this.createToggleButton(new SwitchToText());
        textButton.setModel((ButtonModel)((Object)new VeotableToggleButtonModel()));
        buttons.add((AbstractButton)textButton);
        toolBar.add((Component)textButton);
    }

    private void createStatusBar(E2EBuilderModule module) {
        StatusBar statusBar = new StatusBar();
        statusBar.add((Component)new LabelStatusBarItem(), (Object)"vary");
        ListStatusBarItem charsetItem = new ListStatusBarItem();
        charsetItem.setToolTipText(module.getTranslation("blob.viewer.tooltip.file.encoding", "Select File Encoding"));
        charsetItem.setValues((Object)Charset.defaultCharset(), Charset.availableCharsets().values());
        charsetItem.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueChangedEvent event) {
                BlobViewerDialog.this.charset = (Charset)event.getValue();
                BlobViewerDialog.this.updateTextViewer = true;
                BlobViewerDialog.this.setText();
            }
        });
        statusBar.add((Component)charsetItem, (Object)"flexible");
        this.add((Component)statusBar, "South");
    }

    private JideToggleButton createToggleButton(Action action) {
        JideToggleButton button = new JideToggleButton(action);
        button.setHideActionText(true);
        button.setFocusable(false);
        button.setFocusPainted(false);
        button.setRolloverEnabled(true);
        button.setBorderPainted(false);
        return button;
    }

    private class VeotableToggleButtonModel
    extends JideToggleButton.ToggleButtonModel {
        private VeotableToggleButtonModel() {
        }

        public void setPressed(boolean b) {
            if (b && !this.isSelected()) {
                if (BlobViewerDialog.this.newlineLimitExceeded == null) {
                    BlobViewerDialog.this.newlineLimitExceeded = this.analyzeNewlines();
                }
                if (BlobViewerDialog.this.newlineLimitExceeded.booleanValue()) {
                    if (E2EBuilderQuestionDialog.doYesNoQuestion((String)BlobViewerDialog.this.module.getTranslation("blob.viewer.newline.dialog.title"), (String)BlobViewerDialog.this.module.getTranslation("blob.viewer.newline.dialog.subtitle"), (String)BlobViewerDialog.this.module.getTranslation("blob.viewer.newline.dialog.question"))) {
                        super.setPressed(true);
                        super.setPressed(false);
                    }
                } else {
                    super.setPressed(true);
                }
            } else {
                super.setPressed(b);
            }
        }

        private boolean analyzeNewlines() {
            Iterator<String> chunks = new Iterator<String>(){
                public int offset = 0;

                @Override
                public boolean hasNext() {
                    return this.offset < BlobViewerDialog.this.blob.length;
                }

                @Override
                public String next() {
                    String s = new String(BlobViewerDialog.this.blob, this.offset, this.offset + 10000 < BlobViewerDialog.this.blob.length ? 10000 : BlobViewerDialog.this.blob.length - this.offset, BlobViewerDialog.this.charset);
                    this.offset += 10000;
                    return s;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            boolean exeeded = false;
            int pos = 0;
            int off = 0;
            while (!exeeded && chunks.hasNext()) {
                String chunk = (String)chunks.next();
                int newPos = -1;
                while (!exeeded && (newPos = chunk.indexOf(10, newPos + 1)) != -1) {
                    exeeded = newPos + off - pos > 10000;
                    pos = newPos + off;
                }
                off += chunk.length();
            }
            return exeeded || BlobViewerDialog.this.blob.length - pos > 10000;
        }
    }

    private class SetBlobTransaction
    extends E2EBuilderTransaction {
        private SetBlobTransaction() {
        }

        public Object doTransaction(Object transactionData) throws Throwable {
            BlobViewerDialog.this.setBlob((byte[])transactionData);
            return null;
        }

        public void prepareTransaction() {
        }

        public void setTransactionResult(Object transactionResult) {
        }

        public String getDescription() {
            return "Set BlobViewerDialog data";
        }
    }

    private class SwitchToText
    extends AbstractAction {
        private SwitchToText() {
            super(BlobViewerDialog.TEXT_VIEWER, Constants.TEXT_VIEWER_TEXT_BUTTON_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BlobViewerDialog.this.setText();
            BlobViewerDialog.this.cards.show(BlobViewerDialog.this.viewerPanel, (String)this.getValue("Name"));
        }
    }

    private class SwitchToBase64
    extends AbstractAction {
        public SwitchToBase64() {
            super(BlobViewerDialog.BASE64_VIEWER, Constants.TEXT_VIEWER_BASE64_BUTTON_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BlobViewerDialog.this.setBase64();
            BlobViewerDialog.this.cards.show(BlobViewerDialog.this.viewerPanel, (String)this.getValue("Name"));
        }
    }

    private class SwitchToHex
    extends AbstractAction {
        public SwitchToHex() {
            super(BlobViewerDialog.HEX_VIEWER, Constants.TEXT_VIEWER_HEX_BUTTON_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BlobViewerDialog.this.setHex();
            BlobViewerDialog.this.cards.show(BlobViewerDialog.this.viewerPanel, (String)this.getValue("Name"));
        }
    }
}

