/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.FallbackUmlObject;
import ch.e2e.builder.trace.testcase.uml.Logging;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class UmlObjectFactory
implements Logging {
    private static final String packageName = UmlObjectFactory.class.getPackage().getName();

    private UmlObjectFactory() {
    }

    public static UmlTree createUmlTree(File traceFolder) throws IOException, ParserConfigurationException, SAXException {
        UmlTree umlTree = new UmlTree(traceFolder);
        return umlTree.getChildCount() == 0 ? null : umlTree;
    }

    public static UmlTree createUmlTree(Element element, TraceContainer traceContainer) {
        return new UmlTree(element, traceContainer);
    }

    public static UmlObject createUmlObject(Element element, TraceContainer traceContainer) {
        UmlObject result = null;
        ReflectiveOperationException exception = null;
        try {
            Class<?> clazz = UmlObjectFactory.getClassForElement(element);
            Constructor<?> constructor = clazz.getConstructor(Element.class, TraceContainer.class);
            result = (UmlObject)constructor.newInstance(element, traceContainer);
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (NoSuchMethodException e) {
            exception = e;
        }
        catch (InstantiationException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        if (exception != null) {
            logger.warning(exception.getMessage());
            result = new FallbackUmlObject(element, traceContainer);
        }
        return result;
    }

    public static UmlObject createUmlObject(Element element, TraceContainer traceContainer, boolean addToContainer) {
        UmlObject result = null;
        ReflectiveOperationException exception = null;
        try {
            Class<?> clazz = UmlObjectFactory.getClassForElement(element);
            try {
                Constructor<?> constructor = clazz.getConstructor(Element.class, TraceContainer.class, Boolean.TYPE);
                result = (UmlObject)constructor.newInstance(element, traceContainer, addToContainer ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (NoSuchMethodException nsmEx) {
                Constructor<?> constructor = clazz.getConstructor(Element.class, TraceContainer.class);
                result = (UmlObject)constructor.newInstance(element, traceContainer);
            }
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (InstantiationException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        catch (NoSuchMethodException e) {
            exception = e;
        }
        if (exception != null) {
            logger.warning(exception.getMessage());
            result = new FallbackUmlObject(element, traceContainer);
        }
        return result;
    }

    public static UmlObject createUmlObject(Element element, File documentFolder) {
        UmlObject result;
        try {
            Class<?> clazz = UmlObjectFactory.getClassForElement(element);
            Constructor<?> constructor = clazz.getConstructor(Element.class, File.class);
            result = (UmlObject)constructor.newInstance(element, documentFolder);
        }
        catch (ReflectiveOperationException e) {
            logger.warning(e.getMessage());
            result = new FallbackUmlObject(element, documentFolder);
        }
        return result;
    }

    public static UmlObject createUmlObject(File documentFile) {
        UmlObject result = null;
        try {
            Document document = DomUtilities.parse((File)documentFile, (boolean)false, (boolean)false);
            result = UmlObjectFactory.createUmlObject(document.getDocumentElement(), documentFile.getParentFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Class<?> getClassForElement(Element element) throws ClassNotFoundException {
        StringBuffer name = new StringBuffer(element.getLocalName().replaceAll("-", "_"));
        name.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        return Class.forName(packageName + "." + name);
    }
}

