/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.dom.BridgeNamespaceContext;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeMapper {
    public static final String BASE64BINARY = "base64Binary";
    public static final String BOOLEAN = "boolean";
    public static final String DATETIME = "dateTime";
    public static final String FLOAT = "float";
    public static final String INTEGER = "integer";
    public static final String STRING = "string";
    public static final String ARRAY = "Array";
    public static final String UNKNOWN = "Unknown";
    public static final String EXCEPTION = "Exception";
    public static final String XSD_ = "xsd:";
    public static final List<String> stringTypes = Arrays.asList("string", "normalizedString", "QName", "anyURI", "token", "language", "NMTOKEN", "NMTOKENS", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "Name", "NCName", "NOTATION");
    public static final List<String> blobTypes = Arrays.asList("base64Binary", "hexBinary");
    public static final List<String> arrayTypes = Arrays.asList("Array");
    public static final List<String> booleanTypes = Arrays.asList("boolean");
    public static final List<String> dateTimeTypes = Arrays.asList("dateTime", "time", "date", "duration", "gYearMonth", "gYear", "gMonthDay", "gDay", "gMonth");
    public static final List<String> floatTypes = Arrays.asList("float", "double", "decimal");
    public static final List<String> integerTypes = Arrays.asList("integer", "nonPositiveInteger", "negativeInteger", "long", "int", "short", "nonNegativeInteger", "unsignedLong", "unsignedInt", "unsignedShort", "positiveInteger", "byte", "unsignedByte");

    public static String mapTypes(Element element, BridgeNamespaceContext namespaceContext) {
        String type = TypeMapper.mapType(element, namespaceContext);
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            TypeMapper.mapTypes((Element)child, namespaceContext);
        }
        return type;
    }

    public static String mapType(Element element, BridgeNamespaceContext namespaceContext) {
        String type;
        NamedNodeMap attributes = element.getAttributes();
        Node node = attributes.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (node == null) {
            type = element.getNodeName().equals(EXCEPTION) ? EXCEPTION : UNKNOWN;
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", type);
        } else {
            String soapType = node.getNodeValue();
            if (ARRAY.equals(TypeMapper.soapType2BridgeType(soapType, namespaceContext.getSoapEncodingPrefix()))) {
                String uri = namespaceContext.getNamespaceURI(namespaceContext.getSoapEncodingPrefix());
                Node typeNode = attributes.getNamedItemNS(uri, "itemType");
                String count = "";
                if (typeNode != null) {
                    Node arraySize = attributes.getNamedItemNS(uri, "arraySize");
                    count = "[" + arraySize.getNodeValue() + "]";
                    soapType = typeNode.getNodeValue();
                } else {
                    typeNode = attributes.getNamedItemNS(uri, "arrayType");
                    if (typeNode != null) {
                        soapType = typeNode.getNodeValue();
                        int arrayCountIndex = soapType.indexOf(91);
                        if (arrayCountIndex != -1) {
                            count = soapType.substring(arrayCountIndex);
                            soapType = soapType.substring(0, arrayCountIndex);
                        }
                    } else {
                        throw new IllegalStateException("Neither SOAP 1.1 nor SOAP 1.2");
                    }
                }
                type = TypeMapper.soapType2BridgeType(soapType, namespaceContext) + count;
            } else {
                type = TypeMapper.soapType2BridgeType(soapType, namespaceContext);
            }
            String namespace = TypeMapper.findNamespace(soapType, namespaceContext);
            if (namespace != null && !namespace.isEmpty()) {
                element.setAttribute("namespace", namespace);
            }
            node.setNodeValue(type);
        }
        return type;
    }

    private static String findNamespace(String type, BridgeNamespaceContext context) {
        int idx = type.indexOf(":");
        return idx < 1 ? null : context.getNamespaceURI(type.substring(0, idx));
    }

    public static String soapType2BridgeType(String soapType, BridgeNamespaceContext namespaceContext) {
        String bridgeType;
        int index = soapType.lastIndexOf(":");
        if (index != -1) {
            String prefix = soapType.substring(0, index);
            bridgeType = soapType.substring(index + 1);
            if (prefix.equals(namespaceContext.getPrefix("http://www.w3.org/2001/XMLSchema"))) {
                bridgeType = TypeMapper.xsd2BridgeType(bridgeType);
            }
        } else {
            bridgeType = soapType;
        }
        return bridgeType;
    }

    private static String soapType2BridgeType(String soapType, String namespacePrefix) {
        String prefix;
        String bridgeType = null;
        int index = soapType.lastIndexOf(":");
        if (index != -1 && (prefix = soapType.substring(0, index)).equals(namespacePrefix)) {
            bridgeType = soapType.substring(index + 1);
        }
        return bridgeType;
    }

    private static String xsd2BridgeType(String type) {
        if (stringTypes.contains(type)) {
            type = "Base Types.String";
        } else if (blobTypes.contains(type)) {
            type = "Base Types.Blob";
        } else if (arrayTypes.contains(type)) {
            type = "Base Types.Array";
        } else if (booleanTypes.contains(type)) {
            type = "Base Types.Boolean";
        } else if (dateTimeTypes.contains(type)) {
            type = "Base Types.DateTime";
        } else if (floatTypes.contains(type)) {
            type = "Base Types.Float";
        } else if (integerTypes.contains(type)) {
            type = "Base Types.Integer";
        }
        return type;
    }

    public static String bridgeType2XSD(String type) {
        if (type.equals("Base Types.String")) {
            type = "xsd:string";
        } else if (type.equals("Base Types.Blob")) {
            type = "xsd:base64Binary";
        } else if (type.equals("Base Types.Boolean")) {
            type = "xsd:boolean";
        } else if (type.equals("Base Types.DateTime")) {
            type = "xsd:dateTime";
        } else if (type.equals("Base Types.Float")) {
            type = "xsd:float";
        } else if (type.equals("Base Types.Integer")) {
            type = "xsd:integer";
        }
        return type;
    }

    public static boolean isSimpleType(String type) {
        return type.startsWith(XSD_);
    }
}

