/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.ScriptObject;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.io.ZipUtilities;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Script
extends UmlObject {
    private static final String NAME = "script";
    private String ioId = null;

    public Script() {
        super(NAME);
    }

    public Script(Element element, File documentFolder) {
        this();
        if (element.hasAttribute("id")) {
            this.ioId = element.getAttribute("id");
        }
        this.error = "true".equals(element.getAttribute("error"));
        this.readIOEntry(documentFolder);
    }

    public Script(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
    }

    @Override
    public int internalGetType() {
        return 10000;
    }

    public ScriptObject getScriptPart(int index) {
        return (ScriptObject)this.getChild(index);
    }

    public void cleanScriptParts() {
        int length = this.getChildCount();
        for (int i = 0; i < length; ++i) {
            this.getScriptPart(i).clearXmlElement();
        }
    }

    public String getIoId() {
        return this.ioId;
    }

    public void setIoId(String ioId) {
        this.ioId = ioId;
    }

    private void readIOEntry(File documentFolder) {
        File ioFile = new File(documentFolder, ".io");
        try {
            Document document = ZipUtilities.getZippedDocumentFromFile((File)ioFile, (String)this.getIoId());
            if (document != null) {
                NodeList nodes = document.getDocumentElement().getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (!(node instanceof Element)) continue;
                    this.addChild((Element)node, documentFolder);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }
}

