/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import ch.e2e.builder.trace.testcase.parameter.SimpleTypeParameter;
import ch.e2e.dom.DomUtilities;
import java.math.BigDecimal;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DateTimeParameter
extends SimpleTypeParameter {
    private static DatatypeFactory datatypeFactory = null;

    public DateTimeParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        this(parameterElement, type, arrayItem, parent, definitionHolder, false);
    }

    public DateTimeParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        super(parameterElement, type, arrayItem, parent, definitionHolder, namespaceAware);
    }

    private DateTimeParameter(String name, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        super(name, type, arrayItem, parent, definitionHolder);
    }

    @Override
    public DateTimeParameter copy(RecordParameter parent) {
        DateTimeParameter result = new DateTimeParameter(this.getName(), this.getType(), this.isArrayItem(), parent, this.getDefinitionHolder());
        Object value = this.getValue();
        if (value != null) {
            if (value instanceof XMLGregorianCalendar) {
                result.setValue(datatypeFactory.newXMLGregorianCalendar(((XMLGregorianCalendar)value).toGregorianCalendar()));
            } else if (value instanceof String) {
                try {
                    result.setValue(datatypeFactory.newXMLGregorianCalendar((String)value));
                }
                catch (IllegalArgumentException e) {
                    result.setValue(value);
                }
            }
        }
        return result;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            try {
                super.setValue(datatypeFactory.newXMLGregorianCalendar((String)value));
            }
            catch (IllegalArgumentException e) {
                super.setValue(value);
            }
        } else {
            super.setValue(value);
        }
    }

    @Override
    public boolean importValue(Object value) {
        boolean imported = false;
        if (value == null || value instanceof XMLGregorianCalendar) {
            this.setValue(value);
            imported = true;
        } else {
            try {
                super.setValue(datatypeFactory.newXMLGregorianCalendar(value.toString()));
                imported = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return imported;
    }

    @Override
    public String getDiagramName() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Base Types.DateTime";
    }

    @Override
    Object createValue(Element parameterElement) {
        Object newValue;
        if (parameterElement.getChildNodes().getLength() == 1 && parameterElement.getFirstChild().getNodeType() == 3) {
            String content = parameterElement.getTextContent();
            try {
                newValue = datatypeFactory.newXMLGregorianCalendar(content);
            }
            catch (IllegalArgumentException e) {
                newValue = content;
            }
        } else {
            try {
                newValue = this.createValueOld(parameterElement);
            }
            catch (IllegalArgumentException e) {
                newValue = this.createEmptyParameter(this.getParent());
            }
        }
        return newValue;
    }

    Object createValueOld(Element parameterElement) {
        XMLGregorianCalendar result = datatypeFactory.newXMLGregorianCalendar();
        String value = this.getNodeValue("year", parameterElement);
        if (value != null) {
            try {
                result.setYear(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = this.getNodeValue("month", parameterElement)) != null) {
            try {
                result.setMonth(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = this.getNodeValue("day", parameterElement)) != null) {
            try {
                result.setDay(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = this.getNodeValue("hours", parameterElement)) != null) {
            try {
                result.setHour(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = this.getNodeValue("minutes", parameterElement)) != null) {
            try {
                result.setMinute(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = this.getNodeValue("secondes", parameterElement)) != null) {
            try {
                int idx = value.indexOf(46);
                if (idx > -1) {
                    result.setSecond(Integer.valueOf(value.substring(0, idx)));
                    result.setFractionalSecond(BigDecimal.valueOf(Double.valueOf(value.substring(idx))));
                } else {
                    result.setSecond(Integer.valueOf(value));
                }
            }
            catch (NumberFormatException idx) {
                // empty catch block
            }
        }
        if ((value = this.getNodeValue("timezone", parameterElement)) != null) {
            if (!value.equals("Z")) {
                value = "GMT" + value;
            }
            TimeZone timezone = TimeZone.getTimeZone(value);
            result.setTimezone(timezone.getRawOffset() / 60000);
        }
        return result;
    }

    @Override
    public Parameter createEmptyParameter(RecordParameter parent) {
        return new DateTimeParameter(this.getName(), this.getType(), this.isArrayItem(), parent, this.getDefinitionHolder());
    }

    private String getNodeValue(String nodeName, Element element) {
        String value = null;
        try {
            Node node = (Node)DomUtilities.evaluate((Node)element, (String)(nodeName + "/text()"), (QName)XPathConstants.NODE);
            if (node != null) {
                value = node.getNodeValue();
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return value;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
    }
}

