/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.renderer;

import ch.e2e.swing.filechooser.FileChooserConstants;
import ch.e2e.swing.filechooser.FileChooserIcons;
import ch.e2e.swing.filechooser.FileIconPool;
import ch.e2e.swing.model.Directory;
import ch.e2e.swing.model.FileListModelExtension;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;

public class FileListCellRenderer
extends DefaultListCellRenderer
implements FileChooserIcons {
    private FileListModelExtension modelExtension;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null) {
            if (value instanceof File) {
                super.getListCellRendererComponent((JList<?>)list, ((File)value).getName(), index, isSelected, cellHasFocus);
                this.setDisplayFormat((File)value, isSelected);
            } else if (value instanceof Directory) {
                super.getListCellRendererComponent((JList<?>)list, value.toString(), index, isSelected, cellHasFocus);
                this.setDisplayFormat((Directory)value, isSelected);
            }
        }
        return this;
    }

    public void setFileListModelExtension(FileListModelExtension modelExtension) {
        this.modelExtension = modelExtension;
    }

    public void setDisplayFormat(Directory directory, boolean isSelected) {
        Icon icon = null;
        if (this.modelExtension != null) {
            icon = this.modelExtension.getIcon(directory.getDir());
        }
        if (icon == null) {
            icon = directory.isRoot() && FileChooserConstants.WINDOWS ? discIcon : folderIcon;
        }
        super.setIcon(icon);
        this.setFont(directory.getDir());
        if (!isSelected) {
            this.setColor(directory.getDir());
        }
    }

    public void setDisplayFormat(File file, boolean isSelected) {
        this.setIcon(file);
        this.setFont(file);
        if (!isSelected) {
            this.setColor(file);
        }
    }

    private void setIcon(File file) {
        Icon result = this.modelExtension == null || this.modelExtension.getIcon(file) == null ? FileIconPool.getInstance().getIcon(file) : this.modelExtension.getIcon(file);
        if (result != null) {
            super.setIcon(result);
        }
    }

    private void setFont(File file) {
        Font result;
        Font font = result = this.modelExtension == null ? null : this.modelExtension.getFont(file, this.getFont());
        if (result != null) {
            super.setFont(result);
        }
    }

    private void setColor(File file) {
        Color result;
        Color color = result = this.modelExtension == null ? null : this.modelExtension.getColor(file);
        if (result != null) {
            super.setForeground(result);
        }
    }
}

