/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.swing.event.FileFilterChangedEvent;
import ch.e2e.swing.event.FileFilterChangedEventMulticaster;
import ch.e2e.swing.event.FileFilterListener;
import ch.e2e.swing.model.FileFilterComboBoxModel;
import ch.e2e.swing.renderer.FileFilterComboBoxCellRenderer;
import ch.e2e.swing.util.FileChooserFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;

public class FileFilterComboBox
extends JComboBox {
    private FileFilterListener listener;

    public FileFilterComboBox() {
        this.initialize(new FileChooserFilter[0]);
    }

    public FileFilterComboBox(FileChooserFilter[] filter) {
        this.initialize(filter);
    }

    public void addFileFilter(FileChooserFilter fileFilter) {
        ((FileFilterComboBoxModel)this.getModel()).addFileFilter(fileFilter);
    }

    public int getFileFilterCount() {
        return this.getModel().getSize();
    }

    public void setFileFilter(FileChooserFilter[] fileFilter) {
        ((FileFilterComboBoxModel)this.getModel()).setFileFilter(fileFilter);
    }

    public void setSelectedFilter(FileChooserFilter selectedFilter) {
        this.getModel().setSelectedItem(selectedFilter);
        this.fireFileFilterChangedEvent();
    }

    public void addFileFilterListener(FileFilterListener listener) {
        this.listener = FileFilterChangedEventMulticaster.addListener(this.listener, listener);
    }

    public void removeFileFilterListener(FileFilterListener listener) {
        this.listener = FileFilterChangedEventMulticaster.removeListener(this.listener, listener);
    }

    private void initialize(FileChooserFilter[] filter) {
        this.setModel(new FileFilterComboBoxModel(filter));
        this.setRenderer(new FileFilterComboBoxCellRenderer());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileFilterComboBox.this.fireFileFilterChangedEvent();
            }
        });
    }

    private void fireFileFilterChangedEvent() {
        if (this.listener != null) {
            this.listener.fileFilterChanged(new FileFilterChangedEvent(this, ((FileFilterComboBoxModel)this.getModel()).getSelectedFilter()));
        }
    }
}

