/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.swing.event.DirectorySelectedEvent;
import ch.e2e.swing.event.DirectorySelectedEventMulticaster;
import ch.e2e.swing.event.DirectorySelectedListener;
import ch.e2e.swing.model.Directory;
import ch.e2e.swing.model.DirectoryComboBoxModel;
import ch.e2e.swing.renderer.DirectoryComboBoxCellRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class DirectoryComboBox
extends JComboBox
implements DirectorySelectedListener {
    private DirectorySelectedListener listener;
    private boolean comeFromDirectorySelected = false;

    public DirectoryComboBox() {
        this.setRenderer(new DirectoryComboBoxCellRenderer(this));
        this.setModel(new DirectoryComboBoxModel());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!DirectoryComboBox.this.comeFromDirectorySelected) {
                    DirectoryComboBox.this.fireDirectorySelected();
                }
            }
        });
    }

    public void setSelectedDirectory(File selectedDirectory) {
        this.setSelectedDirectory(Directory.getDirectory(selectedDirectory));
    }

    public void setSelectedDirectory(Directory selectedDirectory) {
        this.getModel().setSelectedItem(selectedDirectory);
    }

    public Directory getSelectedDirectory() {
        return (Directory)this.getModel().getSelectedItem();
    }

    public void addDirectorySelectedListener(DirectorySelectedListener listener) {
        this.listener = DirectorySelectedEventMulticaster.addListener(this.listener, listener);
    }

    public void removeDirectorySelectedListener(DirectorySelectedListener listener) {
        this.listener = DirectorySelectedEventMulticaster.removeListener(this.listener, listener);
    }

    @Override
    public void directorySelected(DirectorySelectedEvent event) {
        this.comeFromDirectorySelected = true;
        this.setSelectedDirectory(event.getDirectory());
        this.comeFromDirectorySelected = false;
    }

    private void fireDirectorySelected() {
        if (this.listener != null) {
            this.listener.directorySelected(new DirectorySelectedEvent(this, this.getSelectedDirectory()));
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        DirectoryComboBox cb = new DirectoryComboBox();
        cb.setSelectedDirectory(Directory.getDirectory(new File("D:/Projects/mceco2/base/java/src")));
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)cb, "Center");
        frame.pack();
        frame.setVisible(true);
    }
}

