/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.resource.Translator;
import ch.e2e.swing.MultiLineLabel;
import ch.e2e.swing.border.SelectSideEtchedBorder;
import ch.e2e.swing.event.CloseControlEvent;
import ch.e2e.swing.event.CloseControlEventMulticaster;
import ch.e2e.swing.event.CloseControlListener;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ModalDialog
extends JDialog {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int NONE = 0;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int OK_CANCEL = 3;
    protected static Translator translator = new Translator("ch.e2e.swing.dialog", Locale.getDefault(), ModalDialog.class.getClassLoader());
    private JPanel viewPanel;
    private int minimumWidth = 100;
    private int maximumWidth = 750;
    private int minimumHeight = 50;
    private int maximumHeight = 550;
    private JPanel southPanel;
    private JPanel leftButtonPanel;
    private JPanel centerButtonPanel;
    private JPanel rightButtonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private ArrayList<AbstractButton> buttons;
    private ButtonActionListener buttonListener;
    private ActionListener okListener;
    private ActionListener cancelListener;
    private CloseControlListener closingListener;
    private JPanel titlePanel;
    private JLabel internalTitle;
    private MultiLineLabel subtitle;
    private JLabel titleLogo;
    private int closeOption;
    private KeyStroke cancelKeyStroke;
    private AbstractAction cancelAction;
    private KeyStroke enterKeyStroke;
    private AbstractAction enterAction;
    private ArrayList<AbstractButton> additionalButtons = new ArrayList();
    private HashMap<AbstractButton, ArrayList<ActionListener>> buttonListeners = new HashMap();
    private JPanel contentPane;
    private boolean oneButtonWidth = true;
    private boolean closedByButton = false;

    public ModalDialog(Frame owner, int type) {
        this(owner, "", "", "", null, type);
    }

    public ModalDialog(Frame owner, String title, int type) {
        this(owner, title, "", "", null, type);
    }

    public ModalDialog(Frame owner, String title, String internalTitle, int type) {
        this(owner, title, internalTitle, "", null, type);
    }

    public ModalDialog(Frame owner, String title, String internalTitle, String subtitle, int type) {
        this(owner, title, internalTitle, subtitle, null, type);
    }

    public ModalDialog(Frame owner, String title, String internalTitle, String subtitle, int type, boolean oneButtonWidth) {
        this(owner, title, internalTitle, subtitle, null, type, oneButtonWidth, true);
    }

    public ModalDialog(Frame owner, String title, String internalTitle, String subtitle, Icon titleLogo, int type) {
        this(owner, title, internalTitle, subtitle, titleLogo, type, true, true);
    }

    public ModalDialog(Frame owner, String title, String internalTitle, String subtitle, Icon titleLogo, int type, boolean oneButtonWidth) {
        this(owner, title, internalTitle, subtitle, titleLogo, type, oneButtonWidth, true);
    }

    public ModalDialog(Frame owner, String title, String internalTitle, String subtitle, Icon titleLogo, int type, boolean oneButtonWidth, boolean modal) {
        super(owner == null ? new JFrame() : owner, title, modal);
        this.oneButtonWidth = oneButtonWidth;
        this.initialize(internalTitle, subtitle, titleLogo, type);
    }

    public ModalDialog(Dialog owner, int type) {
        this(owner, "", "", "", type);
    }

    public ModalDialog(Dialog owner, String title, int type) {
        this(owner, title, "", "", type);
    }

    public ModalDialog(Dialog owner, String title, String internalTitle, int type) {
        this(owner, title, internalTitle, "", type);
    }

    public ModalDialog(Dialog owner, String title, String internalTitle, String subtitle, int type) {
        this(owner, title, internalTitle, subtitle, null, type);
    }

    public ModalDialog(Dialog owner, String title, String internalTitle, String subtitle, Icon titleLogo, int type) {
        this(owner, title, internalTitle, subtitle, titleLogo, type, true, true);
    }

    public ModalDialog(Dialog owner, String title, String internalTitle, String subtitle, Icon titleLogo, int type, boolean oneButtonWidth) {
        this(owner, title, internalTitle, subtitle, titleLogo, type, oneButtonWidth, true);
    }

    public ModalDialog(Dialog owner, String title, String internalTitle, String subtitle, int type, boolean oneButtonWidth) {
        this(owner, title, internalTitle, subtitle, null, type, oneButtonWidth, true);
    }

    public ModalDialog(Dialog owner, String title, String internalTitle, String subtitle, Icon titleLogo, int type, boolean oneButtonWidth, boolean modal) {
        super(owner == null ? new JDialog() : owner, title, modal);
        this.oneButtonWidth = oneButtonWidth;
        this.initialize(internalTitle, subtitle, titleLogo, type);
    }

    public void addCloseControlListener(CloseControlListener closingListener) {
        this.closingListener = CloseControlEventMulticaster.addListener(this.closingListener, closingListener);
    }

    public void removeCloseControlListener(CloseControlListener closingListener) {
        this.closingListener = CloseControlEventMulticaster.removeListener(this.closingListener, closingListener);
    }

    @Override
    public Component add(Component comp) {
        if (this.viewPanel != null) {
            return this.viewPanel.add(comp);
        }
        return super.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        if (this.viewPanel != null) {
            return this.viewPanel.add(comp, index);
        }
        return super.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (this.viewPanel != null) {
            this.viewPanel.add(comp, constraints);
        } else {
            super.add(comp, constraints);
        }
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        if (this.viewPanel != null) {
            this.viewPanel.add(comp, constraints, index);
        } else {
            super.add(comp, constraints, index);
        }
    }

    @Override
    public void remove(Component comp) {
        if (this.viewPanel != null) {
            this.viewPanel.remove(comp);
        } else {
            super.remove(comp);
        }
    }

    @Override
    public void remove(int index) {
        if (this.viewPanel != null) {
            this.viewPanel.remove(index);
        } else {
            super.remove(index);
        }
    }

    @Override
    public void removeAll() {
        if (this.viewPanel != null) {
            this.viewPanel.removeAll();
        } else {
            super.removeAll();
        }
    }

    public int getAddedComponentCount() {
        if (this.viewPanel != null) {
            return this.viewPanel.getComponentCount();
        }
        return 0;
    }

    public void setBorder(Border border) {
        if (this.viewPanel != null) {
            this.viewPanel.setBorder(border);
        }
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (this.viewPanel == null) {
            super.setLayout(layout);
        } else {
            this.viewPanel.setLayout(layout);
        }
    }

    @Override
    public LayoutManager getLayout() {
        LayoutManager layout = this.viewPanel == null ? super.getLayout() : this.viewPanel.getLayout();
        return layout;
    }

    public int showDialog() {
        return this.showDialog(true, true, true);
    }

    public int showDialog(boolean centerOnOwner) {
        return this.showDialog(centerOnOwner, true, true);
    }

    public int showDialog(boolean centerOnOwner, boolean pack) {
        return this.showDialog(centerOnOwner, true, pack);
    }

    public int showDialog(boolean centerOnOwner, boolean centerOnScreen, boolean pack) {
        this.updateGui(pack, centerOnOwner, centerOnScreen);
        return this.showDialogNoGuiUpdate();
    }

    public int showDialogNoGuiUpdate() {
        this.setVisible(true);
        this.removeButtonListeners();
        this.setSize(this.getBounds().width, this.getBounds().height);
        return this.closeOption;
    }

    public void updateGui(boolean pack, boolean centerOnOwner, boolean centerOnScreen) {
        this.setButtonWidth();
        this.closeOption = 2;
        if (pack) {
            this.pack();
            this.pack();
        }
        if (centerOnOwner) {
            this.centerOnOwner();
        } else if (centerOnScreen) {
            this.centerOnScreen();
        }
        this.findButtonListeners();
    }

    private void findButtonListeners() {
        int length = this.additionalButtons.size();
        for (int i = 0; i < length; ++i) {
            ActionListener[] listeners;
            AbstractButton button = this.additionalButtons.get(i);
            ArrayList<ActionListener> listenerList = new ArrayList<ActionListener>();
            for (ActionListener listener : listeners = button.getActionListeners()) {
                if (listener.equals(this.buttonListener)) continue;
                listenerList.add(listener);
                button.removeActionListener(listener);
            }
            this.buttonListeners.put(button, listenerList);
        }
    }

    private void removeButtonListeners() {
        int length = this.additionalButtons.size();
        for (int i = 0; i < length; ++i) {
            AbstractButton button = this.additionalButtons.get(i);
            ArrayList<ActionListener> listenerList = this.buttonListeners.get(button);
            if (listenerList != null) {
                int lengthList = listenerList.size();
                for (int j = 0; j < lengthList; ++j) {
                    ActionListener listener = listenerList.get(j);
                    button.addActionListener(listener);
                }
            }
            this.buttonListeners.remove(button);
        }
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(int maximumWidth) {
        this.maximumWidth = maximumWidth;
    }

    public int getMaximumHeight() {
        return this.maximumHeight;
    }

    public void setMaximumHeight(int maximumHeight) {
        this.maximumHeight = maximumHeight;
    }

    public void removeButton(AbstractButton button) {
        if (this.leftButtonPanel != null) {
            this.leftButtonPanel.remove(button);
        }
        if (this.rightButtonPanel != null) {
            this.rightButtonPanel.remove(button);
        }
        this.centerButtonPanel.remove(button);
        this.buttons.remove(button);
        this.additionalButtons.remove(button);
    }

    public void addButton(AbstractButton button, int alignment) {
        this.addButton(button, alignment, false);
    }

    public void addButton(AbstractButton button, int alignment, boolean closeDialog) {
        if (button != null) {
            if (alignment == 4) {
                this.addRightButton(button, closeDialog);
            } else if (alignment == 2) {
                this.addLeftButton(button, closeDialog);
            }
        }
    }

    public void appendButton(AbstractButton button) {
        this.appendButton(button, false);
    }

    public void appendButton(AbstractButton button, boolean closeDialog) {
        if (button != null) {
            this.appendButton(button, this.centerButtonPanel, closeDialog);
        }
    }

    public void insertButton(AbstractButton button, int index) {
        this.insertButton(button, index, false);
    }

    public void insertButton(AbstractButton button, int index, boolean closeDialog) {
        if (button != null) {
            int buttonCount = this.centerButtonPanel.getComponentCount();
            if (index > buttonCount) {
                this.appendButton(button, this.centerButtonPanel, closeDialog);
            } else {
                if (this.oneButtonWidth) {
                    this.centerButtonPanel.setLayout(new GridLayout(1, buttonCount + 1));
                }
                this.centerButtonPanel.add((Component)button, index);
                if (closeDialog) {
                    button.addActionListener(this.buttonListener);
                    this.additionalButtons.add(button);
                }
                this.buttons.add(button);
            }
        }
    }

    public void addCloseDialogButton(JButton button) {
        button.addActionListener(this.buttonListener);
        this.additionalButtons.add(button);
    }

    public void addOkActionListener(ActionListener listener) {
        this.okListener = AWTEventMulticaster.add(this.okListener, listener);
    }

    public void addCancelActionListener(ActionListener listener) {
        this.cancelListener = AWTEventMulticaster.add(this.cancelListener, listener);
    }

    public void setOkButtonEnabled(boolean enabled) {
        if (this.okButton != null) {
            this.okButton.setEnabled(enabled);
            if (enabled && this.okButton.isVisible()) {
                this.getRootPane().getInputMap(1).put(this.enterKeyStroke, this.enterAction);
            } else {
                this.getRootPane().getInputMap(1).remove(this.enterKeyStroke);
            }
        }
    }

    public void setOkButtonVisible(boolean visible) {
        if (this.okButton != null) {
            this.okButton.setVisible(visible);
            if (this.okButton.isEnabled() && visible) {
                this.getRootPane().getInputMap(1).put(this.enterKeyStroke, this.enterAction);
            } else {
                this.getRootPane().getInputMap(1).remove(this.enterKeyStroke);
            }
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    public void setCancelButtonEnabled(boolean enabled) {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(enabled);
            if (enabled && this.cancelButton.isVisible()) {
                this.getRootPane().getInputMap(1).put(this.cancelKeyStroke, this.cancelAction);
            } else {
                this.getRootPane().getInputMap(1).remove(this.cancelKeyStroke);
            }
        }
    }

    public void setCancelButtonVisible(boolean visible) {
        if (this.cancelButton != null) {
            this.cancelButton.setVisible(visible);
            if (this.cancelButton.isEnabled() && visible) {
                this.getRootPane().getInputMap(1).put(this.cancelKeyStroke, this.cancelAction);
            } else {
                this.getRootPane().getInputMap(1).remove(this.cancelKeyStroke);
            }
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    public String getOkButtonText() {
        return this.okButton == null ? null : this.okButton.getText();
    }

    public void setOkButtonText(String text) {
        if (this.okButton != null) {
            this.okButton.setText(text);
        }
    }

    public String getCancelButtonText() {
        return this.cancelButton == null ? null : this.cancelButton.getText();
    }

    public void setCancelButtonText(String text) {
        if (this.cancelButton != null) {
            this.cancelButton.setText(text);
        }
    }

    public void setTitleLogo(Icon titleLogo) {
        this.titleLogo.setIcon(titleLogo);
        if (titleLogo != null) {
            this.titlePanel.setVisible(true);
        }
    }

    public void setInternalTitle(String internalTitle) {
        this.internalTitle.setText(internalTitle);
        if (internalTitle != null && internalTitle.length() > 0) {
            this.titlePanel.setVisible(true);
        }
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.setText(subtitle);
        if (subtitle != null && subtitle.length() > 0) {
            this.titlePanel.setVisible(true);
        }
    }

    public void setTitlePanelVisible(boolean visible) {
        this.titlePanel.setVisible(visible);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (translator != null) {
            translator.setLocale(locale);
            if (this.okButton != null) {
                this.okButton.setText(translator.getTranslation("ok", "ok"));
            }
            if (this.cancelButton != null) {
                this.cancelButton.setText(translator.getTranslation("cancel", "cancel"));
            }
        }
    }

    public boolean isClosedByButton() {
        return this.closedByButton;
    }

    protected final void cancelDialog() {
        this.cancelDialog(new ActionEvent(this, 1001, "cancel"));
    }

    protected final void cancelDialog(ActionEvent event) {
        if (this.cancelButton != null && this.cancelButton.isEnabled() && this.doOnCancel()) {
            this.closeOption = 2;
            if (this.cancelListener != null) {
                this.cancelListener.actionPerformed(event);
            }
            this.hideDialog(-5001);
        }
    }

    protected final void okDialog() {
        this.okDialog(new ActionEvent(this, 1001, "ok"));
    }

    protected final void okDialog(ActionEvent event) {
        if (this.okButton != null && this.okButton.isEnabled() && this.doOnOk()) {
            this.closeOption = 1;
            if (this.okListener != null) {
                this.okListener.actionPerformed(event);
            }
            this.hideDialog(-5000);
        }
    }

    protected boolean doOnOk() {
        return true;
    }

    protected boolean doOnCancel() {
        return true;
    }

    private void initialize(String internalTitle, String subtitle, Icon titleLogo, int type) {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.contentPane = new JPanel(new BorderLayout(0, 0));
        this.getContentPane().add((Component)this.contentPane, "Center");
        this.viewPanel = new JPanel(new BorderLayout());
        this.contentPane.add((Component)this.viewPanel, "Center");
        this.createTitlePanel(internalTitle, subtitle, titleLogo);
        this.buttonListener = new ButtonActionListener();
        this.addButtons(type);
        this.setWindowEventHandling();
        this.addKeyBindings();
    }

    private void createTitlePanel(String internalTitle, String subtitle, Icon titleLogo) {
        this.titlePanel = new JPanel(new BorderLayout());
        this.titlePanel.setVisible(false);
        this.titlePanel.setOpaque(true);
        this.titlePanel.setBackground(Color.white);
        SelectSideEtchedBorder border = new SelectSideEtchedBorder(4);
        this.titlePanel.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(3, 10, 3, 10)));
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setOpaque(true);
        labelPanel.setBackground(Color.white);
        this.createInternalTitleLabel(internalTitle, labelPanel);
        this.createSubtitleLabel(subtitle, labelPanel);
        this.titlePanel.add((Component)labelPanel, "Center");
        this.createTitleLogo(titleLogo);
        this.contentPane.add((Component)this.titlePanel, "North");
    }

    private void createTitleLogo(Icon logo) {
        this.titleLogo = new JLabel();
        this.titleLogo.setBorder(BorderFactory.createEmptyBorder(3, 10, 5, 5));
        this.titlePanel.add((Component)this.titleLogo, "East");
        if (logo != null) {
            this.titleLogo.setIcon(logo);
            this.titlePanel.setVisible(true);
        }
    }

    private void createInternalTitleLabel(String text, JPanel labelPanel) {
        this.internalTitle = new JLabel("", 2);
        this.internalTitle.setFont(new Font("Dialog", 1, 12));
        this.internalTitle.setBorder(BorderFactory.createEmptyBorder(6, 10, 3, 0));
        this.internalTitle.setVerticalAlignment(3);
        this.internalTitle.setForeground(Color.black);
        labelPanel.add((Component)this.internalTitle, "North");
        if (text != null && text.length() > 0) {
            this.internalTitle.setText(text);
            this.titlePanel.setVisible(true);
        }
    }

    private void createSubtitleLabel(String text, JPanel labelPanel) {
        this.subtitle = new MultiLineLabel("");
        this.subtitle.setHorizontalAlignment(2);
        this.subtitle.setFont(new Font("Dialog", 0, 12));
        this.subtitle.setVerticalAlignment(1);
        this.subtitle.setBorder(BorderFactory.createEmptyBorder(0, 30, 6, 0));
        this.subtitle.setForeground(Color.black);
        labelPanel.add((Component)this.subtitle, "South");
        if (text != null && text.length() > 0) {
            this.subtitle.setText(text);
            this.titlePanel.setVisible(true);
        }
    }

    private void hideDialog(int closeOption) {
        CloseControlEvent event;
        if (this.closingListener != null && !this.closingListener.checkClosing(event = new CloseControlEvent(this, closeOption))) {
            return;
        }
        this.closedByButton = false;
        this.setVisible(false);
        this.dispose();
    }

    private void setWindowEventHandling() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ModalDialog.this.closedByButton = false;
                if (ModalDialog.this.cancelButton == null) {
                    ModalDialog.this.okDialog();
                } else {
                    ModalDialog.this.cancelDialog();
                }
            }
        });
    }

    private void addKeyBindings() {
        InputMap inputMap = this.getRootPane().getInputMap(1);
        ActionMap actionMap = this.getRootPane().getActionMap();
        this.cancelKeyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(this.cancelKeyStroke, "escape");
        this.cancelAction = new AbstractAction("escape"){

            @Override
            public void actionPerformed(ActionEvent event) {
                ModalDialog.this.cancelDialog();
            }
        };
        actionMap.put("escape", this.cancelAction);
        this.enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        inputMap.put(this.enterKeyStroke, "enter");
        this.enterAction = new AbstractAction("enter"){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractButton closeButton = null;
                int length = ModalDialog.this.buttons.size();
                for (int i = 0; i < length; ++i) {
                    AbstractButton button = (AbstractButton)ModalDialog.this.buttons.get(i);
                    if (!button.hasFocus()) continue;
                    closeButton = button;
                }
                if (closeButton == null) {
                    closeButton = ModalDialog.this.okButton == null ? ModalDialog.this.cancelButton : ModalDialog.this.okButton;
                }
                closeButton.doClick();
            }
        };
        actionMap.put("enter", this.enterAction);
    }

    private void addButtons(int type) {
        this.buttons = new ArrayList();
        this.southPanel = new JPanel(new BorderLayout(0, 0));
        if (this.oneButtonWidth) {
            JPanel center = new JPanel(new FlowLayout(2, 0, 0));
            int buttonCount = type == 3 ? 2 : 1;
            this.centerButtonPanel = new JPanel(new GridLayout(1, buttonCount));
            center.add(this.centerButtonPanel);
            center.setBorder(BorderFactory.createEmptyBorder(6, 3, 6, 3));
            this.southPanel.add((Component)center, "Center");
        } else {
            this.centerButtonPanel = new JPanel(new FlowLayout(2, 0, 0));
            this.centerButtonPanel.setBorder(BorderFactory.createEmptyBorder(6, 3, 6, 3));
            this.southPanel.add((Component)this.centerButtonPanel, "Center");
        }
        if ((type & 1) > 0) {
            this.okButton = new JButton(translator.getTranslation("ok", "ok"));
            this.okButton.addActionListener(this.buttonListener);
            this.getRootPane().setDefaultButton(this.okButton);
            this.buttons.add(this.okButton);
            this.centerButtonPanel.add(this.okButton);
            this.okButton.doLayout();
            this.getRootPane().setDefaultButton(this.okButton);
        }
        if ((type & 2) > 0 || type == 0) {
            this.cancelButton = new JButton(translator.getTranslation("cancel", "cancel"));
            this.cancelButton.addActionListener(this.buttonListener);
            this.buttons.add(this.cancelButton);
            this.centerButtonPanel.add(this.cancelButton);
            this.cancelButton.doLayout();
            if (this.okButton == null) {
                this.getRootPane().setDefaultButton(this.cancelButton);
            }
        }
        this.southPanel.setBorder(BorderFactory.createCompoundBorder(new SelectSideEtchedBorder(1), BorderFactory.createEmptyBorder(6, 3, 6, 3)));
        if (type != 0) {
            this.contentPane.add((Component)this.southPanel, "South");
        }
    }

    private void addRightButton(AbstractButton button, boolean closeDialog) {
        if (this.rightButtonPanel == null) {
            if (this.oneButtonWidth) {
                JPanel right = new JPanel(new FlowLayout(2, 0, 0));
                right.setBorder(BorderFactory.createEmptyBorder(6, 3, 6, 3));
                this.rightButtonPanel = new JPanel();
                right.add(this.rightButtonPanel);
                this.southPanel.add((Component)right, "East");
            } else {
                this.rightButtonPanel = new JPanel(new FlowLayout(2, 0, 0));
                this.rightButtonPanel.setBorder(BorderFactory.createEmptyBorder(6, 3, 6, 3));
                this.southPanel.add((Component)this.rightButtonPanel, "East");
            }
        }
        this.appendButton(button, this.rightButtonPanel, closeDialog);
    }

    private void addLeftButton(AbstractButton button, boolean closeDialog) {
        if (this.leftButtonPanel == null) {
            if (this.oneButtonWidth) {
                JPanel left = new JPanel(new FlowLayout(0, 0, 0));
                left.setBorder(BorderFactory.createEmptyBorder(6, 3, 6, 3));
                this.leftButtonPanel = new JPanel();
                left.add(this.leftButtonPanel);
                this.southPanel.add((Component)left, "West");
            } else {
                this.leftButtonPanel = new JPanel(new FlowLayout(2, 0, 0));
                this.leftButtonPanel.setBorder(BorderFactory.createEmptyBorder(6, 3, 6, 3));
                this.southPanel.add((Component)this.leftButtonPanel, "West");
            }
        }
        this.appendButton(button, this.leftButtonPanel, closeDialog);
    }

    private void appendButton(AbstractButton button, JPanel buttonPanel, boolean closeDialog) {
        if (this.oneButtonWidth) {
            int columnCount = buttonPanel.getComponentCount() + 1;
            buttonPanel.setLayout(new GridLayout(1, columnCount));
        }
        buttonPanel.add(button);
        this.buttons.add(button);
        if (closeDialog) {
            button.addActionListener(this.buttonListener);
            this.additionalButtons.add(button);
        }
    }

    private void setButtonWidth() {
        if (this.oneButtonWidth) {
            AbstractButton button;
            int i;
            int maxWidth = 0;
            int length = this.buttons.size();
            for (i = 0; i < length; ++i) {
                button = this.buttons.get(i);
                if (!button.isVisible()) continue;
                button.doLayout();
                maxWidth = Math.max(button.getPreferredSize().width, maxWidth);
            }
            for (i = 0; i < length; ++i) {
                button = this.buttons.get(i);
                button.setPreferredSize(new Dimension(maxWidth, button.getPreferredSize().height));
            }
        }
    }

    private void centerOnOwner() {
        this.center(this.getOwner().getBounds());
    }

    private void centerOnScreen() {
        this.center(new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize()));
    }

    private void center(Rectangle bounds) {
        int yPos;
        Dimension dialogSize = this.getSize();
        boolean sizeChanged = false;
        if (dialogSize.width < this.getMinimumWidth()) {
            dialogSize.width = this.getMinimumWidth();
            this.setSize(dialogSize);
            sizeChanged = true;
        } else if (dialogSize.width > this.getMaximumWidth()) {
            int titleHeight;
            int height = titleHeight = this.titlePanel.getHeight();
            int viewHeight = this.viewPanel.getHeight();
            height += viewHeight;
            int southHeight = this.southPanel.getHeight();
            height += southHeight;
            dialogSize.width = this.getMaximumWidth();
            this.setSize(dialogSize);
            SwingUtilities.updateComponentTreeUI(this);
            this.doLayout();
            SwingUtilities.updateComponentTreeUI(this);
            int newHeight = titleHeight = Math.max(titleHeight, this.titlePanel.getHeight());
            viewHeight = Math.max(viewHeight, this.viewPanel.getPreferredSize().height);
            newHeight += viewHeight;
            southHeight = Math.max(southHeight, this.southPanel.getHeight());
            dialogSize.width = this.getMaximumWidth();
            if ((newHeight += southHeight) > height) {
                dialogSize.height += newHeight - height + 5;
            }
            sizeChanged = true;
        }
        if (dialogSize.height < this.getMinimumHeight()) {
            dialogSize.height = this.getMinimumHeight();
            sizeChanged = true;
        } else if (dialogSize.height > this.getMaximumHeight()) {
            dialogSize.height = this.getMaximumHeight();
            sizeChanged = true;
        }
        int xPos = bounds.x + (bounds.width - dialogSize.width) / 2;
        if (xPos < 0) {
            xPos = 0;
        }
        if ((yPos = bounds.y + (bounds.height - dialogSize.height) / 2) < 0) {
            yPos = 0;
        }
        this.setBounds(xPos, yPos, dialogSize.width, dialogSize.height);
        if (sizeChanged) {
            this.doLayout();
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource().equals(ModalDialog.this.cancelButton)) {
                ModalDialog.this.closedByButton = true;
                ModalDialog.this.cancelDialog(event);
                ModalDialog.this.closedByButton = false;
            } else if (event.getSource().equals(ModalDialog.this.okButton)) {
                ModalDialog.this.closedByButton = true;
                ModalDialog.this.okDialog(event);
                ModalDialog.this.closedByButton = false;
            } else {
                ArrayList listenerList = (ArrayList)ModalDialog.this.buttonListeners.get(event.getSource());
                if (listenerList != null) {
                    int length = listenerList.size();
                    for (int i = 0; i < length; ++i) {
                        ActionListener listener = (ActionListener)listenerList.get(i);
                        listener.actionPerformed(event);
                    }
                }
                ModalDialog.this.hideDialog(-5001);
            }
        }
    }
}

