/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.event.ValueChangedEvent;
import ch.e2e.gui.event.ValueChangedListener;
import ch.e2e.swing.RolloverListCellRenderer;
import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.SearchableUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListStatusBarItem<T>
extends LabelStatusBarItem {
    private EventListenerList listeners = new EventListenerList();
    private JList list = new JList();
    private JPopupMenu popup = new JPopupMenu();

    public ListStatusBarItem() {
        this.popup.add((Component)new JideScrollPane((Component)this.list));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ListStatusBarItem.this.popup.show((Component)e.getSource(), 0, 0);
            }
        });
        SearchableUtils.installSearchable((JList)this.list);
        new RolloverListCellRenderer(this.list);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListStatusBarItem.this.setSelectedValue(ListStatusBarItem.this.list.getSelectedValue());
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ListStatusBarItem.this.popup.setVisible(false);
            }
        });
    }

    public ListStatusBarItem(String name) {
        super(name);
        this.popup.add((Component)new JideScrollPane((Component)this.list));
        this.addMouseListener(new /* invalid duplicate definition of identical inner class */);
        SearchableUtils.installSearchable((JList)this.list);
        new RolloverListCellRenderer(this.list);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new /* invalid duplicate definition of identical inner class */);
        this.list.addMouseListener(new /* invalid duplicate definition of identical inner class */);
    }

    public void setValues(Collection<? extends T> values) {
        this.setValues(values.iterator().next(), values);
    }

    public void setValues(T initialValue, Collection<? extends T> values) {
        this.setSelectedValue(initialValue);
        this.list.setModel(new ListModel<T>(new ArrayList<T>(values)));
        this.list.setSelectedValue(initialValue, true);
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.listeners.add(ValueChangedListener.class, listener);
    }

    public void removeValueChangedListener(ValueChangedListener listener) {
        this.listeners.remove(ValueChangedListener.class, listener);
    }

    private void setSelectedValue(T value) {
        this.setText(value.toString());
        ValueChangedEvent event = null;
        for (ValueChangedListener listener : (ValueChangedListener[])this.listeners.getListeners(ValueChangedListener.class)) {
            if (event == null) {
                event = new ValueChangedEvent((Object)this, value);
            }
            listener.valueChanged(event);
        }
    }

    private static class ListModel<T>
    extends AbstractListModel {
        private final List<T> delegate;

        public ListModel(List<T> values) {
            this.delegate = values;
        }

        @Override
        public int getSize() {
            return this.delegate.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.delegate.get(index);
        }
    }
}

