/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.regtest.model.TreePathElement;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.Library;
import ch.e2e.builder.regtest.testsuite.LibraryChildSuite;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.dom.DomUtilities;
import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestSuite;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.ErrorElement;
import ch.e2e.test.TestLogfile;
import ch.e2e.test.Testable;
import ch.e2e.test.Utilities;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import junit.framework.TestResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Testcase
extends E2ETestcase
implements TreePathElement {
    public static final int TESTCASE = 10;
    public static final int TESTCASE_NO_ERRORS = 11;
    public static final int TESTCASE_ERRORS = 12;
    public static final int TESTCASE_IN_LIBRARY = 13;
    public static final int TESTCASE_IN_LIBRARY_NO_ERRORS = 14;
    public static final int TESTCASE_IN_LIBRARY_ERRORS = 15;
    private File logFolder;
    private Integer type = null;
    private boolean run;

    public Testcase(Element testcase, File parentFile, TreeTestSuite parent) throws IllegalAccessException, ClassNotFoundException, InstantiationException, InvocationTargetException {
        super(testcase, parentFile);
        this.setParent(parent);
        this.run = false;
    }

    public Testcase(String name, E2ETest test, TreeTestSuite parent) {
        super(name, test, (E2ETestSuite)parent);
        this.run = false;
    }

    public void rename(String name) {
        String oldName = this.getName();
        this.setName(name);
        if (this.getTest() != null) {
            this.getTest().rename(name);
        }
        if (this.isRun()) {
            ((TreeTestSuite)this.getParent()).renameErrorListEntry(name, oldName);
        }
    }

    public File getLogfileDefault() {
        return new File(this.getLogFolder(), this.getName() + ".log");
    }

    public File getLogFolder() {
        if (this.logFolder == null) {
            this.logFolder = new File(((TreeTestSuite)this.getParent()).getLogFolder(), this.getParent().getName());
        }
        return this.logFolder;
    }

    public Object getChild(int index) {
        Object result = this.isLogfileSet() && index == 0 ? this.getLogfile() : this.getErrors().get(index - (this.isLogfileSet() ? 1 : 0));
        return result;
    }

    public int getChildCount() {
        return this.isLogfileSet() ? this.getErrors().size() + 1 : this.getErrors().size();
    }

    public int getIndexOfChild(Object child) {
        return 0;
    }

    public boolean isLeaf() {
        return this.getErrors().size() == 0 && !this.isLogfileSet();
    }

    public int getType() {
        return this.type == null ? this.createType() : this.type;
    }

    public void addLogfile() {
        File logfile = this.getLogfileDefault();
        this.getTest().setLogfile(new TestLogfile(logfile, false));
        this.setLogfileSet(true);
        try {
            Document testSuiteDocument = DomUtilities.parse((File)this.getParent().getTestSuiteFile(), (boolean)false, (boolean)false, (boolean)false);
            DomUtilities.removeAllNotElementEmptyNodes((Element)testSuiteDocument.getDocumentElement());
            Element logfileElement = testSuiteDocument.createElement("logfile");
            logfileElement.setAttribute("name", logfile.getAbsolutePath());
            Element testcaseElement = (Element)DomUtilities.selectNode((Node)testSuiteDocument.getDocumentElement(), (String)("/testcases/testcase[@name='" + StringTools.escapeXpath((String)this.getName()) + "']"));
            testcaseElement.insertBefore(logfileElement, testcaseElement.getFirstChild());
            DomUtilities.serialize((File)this.getParent().getTestSuiteFile(), (Document)testSuiteDocument, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeLogfile() {
        if (this.isLogfileSet()) {
            if (this.getLogfile().exists()) {
                this.getLogfile().delete();
            }
            if (this.getParent() != null) {
                this.getTest().setLogfile(this.getParent().getLogfile());
            }
            this.setLogfileSet(false);
            try {
                Document testSuiteDocument = DomUtilities.parse((File)this.getParent().getTestSuiteFile(), (boolean)false, (boolean)false, (boolean)false);
                Element logfileElement = (Element)DomUtilities.selectNode((Node)testSuiteDocument.getDocumentElement(), (String)("/testcases/testcase[@name='" + StringTools.escapeXpath((String)this.getName()) + "']/logfile"));
                if (logfileElement != null) {
                    logfileElement.getParentNode().removeChild(logfileElement);
                    DomUtilities.serialize((File)this.getParent().getTestSuiteFile(), (Document)testSuiteDocument, (boolean)true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void persist(String oldName) {
        ((TreeTestSuite)this.getParent()).persist(this, oldName);
    }

    public Element toXml(Document ownerDocument) {
        return super.toXml(ownerDocument);
    }

    @Override
    public Object getTreeParent() {
        return this.getParent();
    }

    @Override
    public boolean isDescendant(TreePathElement element) {
        if (element != null) {
            Object parent = element.getTreeParent();
            while (parent instanceof TreePathElement) {
                if (this.equals(parent)) {
                    return true;
                }
                parent = ((TreePathElement)parent).getTreeParent();
            }
        }
        return false;
    }

    public Library getLibrary() {
        Object parent = this.getTreeParent();
        while (parent instanceof TreePathElement) {
            if (!(parent instanceof LibraryChildSuite) && parent instanceof Library) {
                return (Library)parent;
            }
            parent = ((TreePathElement)parent).getTreeParent();
        }
        return null;
    }

    public void removeData() {
        if (this.getTest() != null) {
            if (this.isInLibrary() && !LibrariesRoot.isInLibraryTree(this)) {
                this.getTest().removeOutputData();
            } else {
                this.getTest().removeData();
            }
        }
    }

    public boolean isRun() {
        return this.run;
    }

    public void setRun(boolean run) {
        this.run = run;
    }

    public void run(TestResult result) {
        super.run(result);
        this.run = true;
        TreeTestSuite parent = (TreeTestSuite)this.getParent();
        if (!parent.isRunning()) {
            parent.addToErrorList(this);
        }
    }

    public void acceptChanges() throws IOException {
        this.getResult().test2Reference(Utilities.collectProperties((Testable)this));
        this.getTest().clear();
        this.run = false;
        ((TreeTestSuite)this.getParent()).removeFromErrorList(this);
    }

    public void moveReferenceData(File oldReferenceFolder, File newReferenceFolder) {
        if (this.getTest() != null) {
            this.getTest().moveReferenceData(oldReferenceFolder, newReferenceFolder);
        }
    }

    public void moveSourceData(File oldSourceFolder, File newSourceFolder) {
        if (this.getTest() != null) {
            this.getTest().moveSourceData(oldSourceFolder, newSourceFolder);
        }
    }

    public Element getErrorsElement(Document errorsDocument) {
        Element testcase = errorsDocument.createElement("Testcase");
        testcase.setAttribute("name", this.getName());
        for (ErrorElement error : this.getErrors()) {
            error.appendTo(testcase);
        }
        return testcase;
    }

    public String getFullQualifiedName() {
        return ((TreeTestSuite)this.getParent()).getPath() + '/' + this.getName();
    }

    private Integer createType() {
        this.type = this.isInLibrary() && !LibrariesRoot.isInLibraryTree(this) ? 13 : 10;
        return this.type;
    }
}

