/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoUnit;

public class DateTimeUtil {
    public static final DateTimeFormatter LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    public static final DateTimeFormatter OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendOffset("+HHMMss", "Z").toFormatter();

    private DateTimeUtil() {
    }

    public static String formatLocalDateTime(LocalDateTime dateTime) {
        return dateTime.truncatedTo(ChronoUnit.SECONDS).format(LOCAL_DATE_TIME);
    }

    public static String formatLocalDateTime(String utcTimestamp) {
        return DateTimeUtil.formatLocalDateTime(Instant.parse(utcTimestamp));
    }

    public static String formatLocalDateTime(Instant instant) {
        return DateTimeUtil.formatLocalDateTime(instant, ZoneId.systemDefault());
    }

    static String formatLocalDateTime(Instant instant, ZoneId zoneId) {
        return instant == null ? null : DateTimeUtil.formatLocalDateTime(LocalDateTime.ofInstant(instant, zoneId));
    }

    public static Instant toInstant(String utcTimestamp) {
        return utcTimestamp == null ? null : Instant.parse(utcTimestamp);
    }

    public static OffsetDateTime toOffsetDateTime(String timestamp) {
        return OffsetDateTime.parse(timestamp, OFFSET_DATE_TIME);
    }
}

