/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.error;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.ErrorHelper;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractLocatedError
extends AbstractBuilderError {
    private String location;
    private String originalElement;

    public AbstractLocatedError(String code, Map<String, String> parameter, String location) {
        this(code, parameter, location, null);
    }

    public AbstractLocatedError(String code, Map<String, String> parameter, String location, String originalElement) {
        super(code, parameter);
        this.location = location;
        this.originalElement = originalElement;
    }

    public AbstractLocatedError(Element errorElement) {
        super(errorElement);
        this.location = ErrorHelper.readLocation(errorElement);
        this.originalElement = ErrorHelper.readOriginalElement(errorElement);
    }

    public String getLocation() {
        return this.location;
    }

    public String getOriginalElement() {
        return this.originalElement;
    }

    @Override
    public Element toNode(Document parent) {
        Element errorElement = super.toNode(parent);
        ErrorHelper.appendLocation(errorElement, this.location);
        if (this.originalElement != null && !this.originalElement.trim().equals("")) {
            ErrorHelper.appendOriginalElement(errorElement, this.originalElement);
        }
        return errorElement;
    }

    @Override
    public boolean equals(Object other) {
        boolean result = super.equals(other);
        if (result && other != null && other instanceof AbstractLocatedError) {
            result = this.equals((AbstractLocatedError)other);
        }
        return result;
    }

    public boolean equals(AbstractLocatedError error) {
        return this.location == null && error.location == null || this.location != null && this.location.equals(error.location);
    }

    @Override
    public int hashCode() {
        String paramString = this.getParameter().toString();
        String hashString = this.getCode() + paramString + this.location;
        return hashString.hashCode();
    }
}

