/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.tree;

import ch.e2e.builder.analyzer.Analyzer;
import ch.e2e.builder.analyzer.model.TransactionLog;
import ch.e2e.builder.analyzer.model.TransactionLogObject;
import ch.e2e.builder.analyzer.model.TransactionLogsRoot;
import ch.e2e.builder.analyzer.model.event.DeleteTransactionLogEvent;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.ModulePopupMenu;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.trace.gui.model.TreeModel;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.functors.FilterIterator;
import ch.e2e.functors.Predicate;
import ch.e2e.swing.model.AbstractTreeModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class TransactionLogTreeModel
extends TreeModel
implements ProjectListener {
    public static final String POPUP_MENU_DELETE = "tree.transactionLog.popup.menu.delete";
    private static final String PROPERTIES = "ch.e2e.builder.analyzer.properties.tree";
    private final TransactionLogsRoot root;
    private final Analyzer analyzer;
    private TransactionLogPopupMenu transactionLogPopup;

    public TransactionLogTreeModel(TransactionLogsRoot root, Analyzer analyzer) {
        super(PROPERTIES);
        this.root = root;
        this.analyzer = analyzer;
        analyzer.addProjectListener(this);
    }

    public Object getRoot() {
        return this.root;
    }

    public JPopupMenu getPopupMenu(TreePath[] paths) {
        Object o;
        TransactionLogPopupMenu popup = null;
        if (paths != null && paths.length > 0 && (o = paths[0].getLastPathComponent()) instanceof TransactionLog) {
            popup = this.getTransactionLogPopupMenu(paths[0]);
        }
        return popup;
    }

    public Object getChild(Object parent, int index) {
        return parent instanceof TransactionLogObject ? ((TransactionLogObject)parent).getChild(index) : null;
    }

    public int getChildCount(Object node) {
        return node instanceof TransactionLogObject ? ((TransactionLogObject)node).getChildCount() : 0;
    }

    public int getIndexOfChild(Object node, Object child) {
        return node instanceof TransactionLogObject ? ((TransactionLogObject)node).getIndexOfChild(child) : -1;
    }

    public int getType(Object node) {
        return node instanceof TransactionLogObject ? ((TransactionLogObject)node).getType() : -1;
    }

    public boolean isLeaf(Object node) {
        return node instanceof TransactionLogObject ? ((TransactionLogObject)node).isLeaf() : super.isLeaf(node);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public String getTypeString(int type) {
        String result = "treenode.unknown";
        switch (type) {
            case 1: {
                result = "treenode.transactionLog.folder";
                break;
            }
            case 2: {
                result = "treenode.transactionLog";
                break;
            }
            case 3: {
                result = "treenode.transactionLog.transaction";
                break;
            }
            case 4: {
                result = "treenode.transactionLog.request";
                break;
            }
            case 5: {
                result = "treenode.transactionLog.entry";
                break;
            }
            case 6: {
                result = "treenode.transactionLog.entry.message";
                break;
            }
            case 7: {
                result = "treenode.transactionLog.entry.message.error";
                break;
            }
            case 8: {
                result = "treenode.transactionLog.entry.reply";
                break;
            }
            case 9: {
                result = "treenode.transactionLog.entry.reply.error";
                break;
            }
            case 10: {
                result = "treenode.transactionLog.entry.attribute";
                break;
            }
            case 11: {
                result = "treenode.transactionLog.entry.custom";
            }
        }
        return result;
    }

    public void doAfterProjectOpen(ProjectEvent event) {
        this.root.projectOpened(event.getProject());
    }

    public void doBeforeChanging(ProjectEvent event) throws EventExecutionVetoException {
    }

    public void doBeforeProjectOpen(ProjectEvent event) {
    }

    public void projectOpened(ProjectEvent event) {
    }

    public void projectSettingsChange(ProjectEvent event) {
    }

    private TransactionLogPopupMenu getTransactionLogPopupMenu(TreePath path) {
        if (this.transactionLogPopup == null) {
            this.transactionLogPopup = new TransactionLogPopupMenu(this.analyzer);
        }
        this.transactionLogPopup.setPath(path);
        return this.transactionLogPopup;
    }

    public static class Searcher
    implements TreeModelListener {
        private final AbstractTreeModel model;
        private Predicate<Object> predicate;
        private ArrayList<Object> matches = new ArrayList();
        private EventListenerList listeners = new EventListenerList();

        public Searcher(AbstractTreeModel model) {
            this.model = model;
            model.addTreeModelListener((TreeModelListener)this);
        }

        public ArrayList<Object> search(Predicate<Object> predicate) {
            this.predicate = predicate;
            this.loadModel();
            return this.getMatches();
        }

        public ArrayList<Object> getMatches() {
            return this.matches;
        }

        public int getMatchCount() {
            return this.matches.size();
        }

        public boolean hasMatches() {
            return !this.matches.isEmpty();
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.loadModel();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.loadModel();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.loadModel();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.loadModel();
        }

        private void loadModel() {
            this.matches.clear();
            Iterator<Object> iterator = this.getIterator();
            while (iterator.hasNext()) {
                this.matches.add(iterator.next());
            }
        }

        private Iterator<Object> getIterator() {
            return new FilterIterator(this.model.depthFirstIterator(this.model.getRoot()), this.predicate);
        }
    }

    public static class TransactionLogPopupMenu
    extends ModulePopupMenu {
        private TransactionLog transactionLog;

        public TransactionLogPopupMenu(Analyzer analyzer) {
            super((E2EBuilderModule)analyzer);
            final JMenuItem delete = ComponentFactory.createMenuItem((String)TransactionLogTreeModel.POPUP_MENU_DELETE, (E2EBuilderModule)analyzer);
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventController.fire((EventObject)new DeleteTransactionLogEvent((Object)delete, transactionLog));
                }
            });
            this.add(delete);
        }

        public void setPath(TreePath path) {
            this.transactionLog = (TransactionLog)path.getLastPathComponent();
        }
    }
}

