/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.Value;
import org.w3c.dom.Element;

public class Multiplicity {
    public static final int SINGLE = 0;
    public static final int SINGLE_2_N = 1;
    public static final int ZERO = 2;
    public static final int ZERO_2_ONE = 3;
    public static final int ZERO_2_N = 4;
    public static final int N = 5;
    private static final Multiplicity MULTIPLICITY_SINGLE = new Multiplicity(0, 1, 1);
    private static final Multiplicity MULTIPLICITY_SINGLE_2_N = new Multiplicity(1, 1, -1);
    private static final Multiplicity MULTIPLICITY_ZERO = new Multiplicity(2, Integer.MIN_VALUE, Integer.MIN_VALUE);
    private static final Multiplicity MULTIPLICITY_ZERO_2_ONE = new Multiplicity(3, Integer.MIN_VALUE, 1);
    private static final Multiplicity MULTIPLICITY_ZERO_2_N = new Multiplicity(4, Integer.MIN_VALUE, -1);
    private static final Multiplicity MULTIPLICITY_N = new Multiplicity(5, -1, -1);
    private static final Multiplicity EMPTY_MULTIPLICITY = new EmptyValue();
    private Value upperValue;
    private Value lowerValue;
    private int multiplicity;

    private Multiplicity(Multiplicity multiplicity) {
        this.multiplicity = multiplicity.multiplicity;
        try {
            this.lowerValue = (Value)multiplicity.lowerValue.clone();
            this.upperValue = (Value)multiplicity.upperValue.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    private Multiplicity(int multiplicity, Object lowerValue, Object upperValue) {
        this.multiplicity = multiplicity;
        this.lowerValue = new Value("lowerValue", "uml:LiteralInteger");
        this.lowerValue.setValue(lowerValue);
        this.upperValue = new Value("upperValue", "uml:LiteralUnlimitedNatural");
        this.upperValue.setValue(upperValue);
    }

    public static Multiplicity createMultiplicity(int multiplicity) {
        Multiplicity result;
        switch (multiplicity) {
            case 0: {
                result = new Multiplicity(MULTIPLICITY_SINGLE);
                break;
            }
            case 1: {
                result = new Multiplicity(MULTIPLICITY_SINGLE_2_N);
                break;
            }
            case 2: {
                result = new Multiplicity(MULTIPLICITY_ZERO);
                break;
            }
            case 3: {
                result = new Multiplicity(MULTIPLICITY_ZERO_2_ONE);
                break;
            }
            case 4: {
                result = new Multiplicity(MULTIPLICITY_ZERO_2_N);
                break;
            }
            case 5: {
                result = new Multiplicity(MULTIPLICITY_N);
                break;
            }
            default: {
                result = new Multiplicity(MULTIPLICITY_ZERO_2_N);
            }
        }
        return result;
    }

    public static Multiplicity createMultiplicity(int lower, int upper) {
        Multiplicity multiplicity = null;
        if (lower == 0) {
            multiplicity = upper == 0 ? new Multiplicity(MULTIPLICITY_ZERO) : (upper == 1 ? new Multiplicity(MULTIPLICITY_ZERO_2_ONE) : new Multiplicity(MULTIPLICITY_ZERO_2_N));
        } else if (lower > 0) {
            multiplicity = upper == 1 ? new Multiplicity(MULTIPLICITY_SINGLE) : new Multiplicity(MULTIPLICITY_SINGLE_2_N);
        } else if (lower == -1 && upper != 0) {
            multiplicity = new Multiplicity(MULTIPLICITY_N);
        }
        if (multiplicity == null) {
            multiplicity = new Multiplicity(MULTIPLICITY_SINGLE);
        }
        return multiplicity;
    }

    public static Multiplicity getEmptyValue() {
        return EMPTY_MULTIPLICITY;
    }

    public boolean isRequired() {
        return this.multiplicity == 0 || this.multiplicity == 1;
    }

    public boolean multipleInstancesAllowed() {
        return this.multiplicity == 1 || this.multiplicity == 4;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Multiplicity ? this.equals((Multiplicity)obj) : super.equals(obj);
    }

    public boolean equals(Multiplicity obj) {
        return obj != null && this.multiplicity == obj.multiplicity;
    }

    public Value getLowerValue() {
        return this.lowerValue;
    }

    public void setLowerValue(int value, String xmiId) {
        this.lowerValue.setValue(value);
        this.lowerValue.setXmiID(xmiId);
    }

    public Value getUpperValue() {
        return this.upperValue;
    }

    public void setUpperValue(int value, String xmiId) {
        this.upperValue.setValue(value);
        this.upperValue.setXmiID(xmiId);
    }

    public void appendToXMI(Element parent, XmiIDFactory xmiIDFactory) {
        String parentXmiId = parent.getAttributeNS("http://schema.omg.org/spec/XMI/2.1", "id");
        parent.appendChild(this.upperValue.toXMI(parent.getOwnerDocument(), parentXmiId, xmiIDFactory));
        parent.appendChild(this.lowerValue.toXMI(parent.getOwnerDocument(), parentXmiId, xmiIDFactory));
    }

    public static class EmptyValue
    extends Multiplicity {
        public EmptyValue() {
            super(0, 0, 0);
        }

        @Override
        public void appendToXMI(Element parent, XmiIDFactory xmiIDFactory) {
        }
    }
}

