/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.ActivityNode;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.BridgeParameter;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.InputPin;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.OutputPin;
import ch.e2e.builder.compiler.uml.Pin;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CallOperationAction
extends ActivityNode {
    private BridgeOperation operation;
    private Map<BridgeParameter, List<Pin>> pins;

    public CallOperationAction(BridgeOperation operation, Module module, Helpers helpers) {
        super(operation.getName(), helpers);
        this.operation = operation;
        this.pins = new HashMap<BridgeParameter, List<Pin>>();
        for (UmlElement child : operation.getParameters()) {
            Pin pin;
            BridgeParameter parameter = (BridgeParameter)child;
            if (parameter.getDirection().equals((Object)Direction.IN) || parameter.getDirection().equals((Object)Direction.INOUT)) {
                pin = new InputPin(parameter, helpers);
                this.initializePin(parameter, pin, module);
            }
            if (parameter.getDirection().equals((Object)Direction.OUT) || parameter.getDirection().equals((Object)Direction.RETURN) || parameter.getDirection().equals((Object)Direction.INOUT)) {
                pin = new OutputPin(parameter, helpers);
                this.initializePin(parameter, pin, module);
            }
            if (!parameter.getName().equals("self")) continue;
            parameter.setName("_self");
        }
    }

    private void initializePin(BridgeParameter parameter, Pin pin, Module module) {
        pin.setModule(module);
        parameter.copyStereotypesAndProperties(pin);
        this.addChild(pin);
        List<Pin> pins = this.pins.get(parameter);
        if (pins == null) {
            pins = new ArrayList<Pin>();
            this.pins.put(parameter, pins);
        }
        pins.add(pin);
    }

    public List<Pin> getPins(BridgeParameter parameter) {
        return this.pins.get(parameter);
    }

    @Override
    public String getBaseclass() {
        return "CallOperationAction";
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element result = super.toXMI(ownerDocument, xmiIDFactory);
        if (this.checkModule(this.operation.getModule())) {
            result.setAttribute("operation", this.operation.getXmiID());
        } else {
            Element typeElement = this.createModuleLink(this.operation, "operation", ownerDocument, xmiIDFactory);
            result.appendChild(typeElement);
        }
        return result;
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        return this.toXMI(ownerDocument, xmiIDFactory);
    }

    @Override
    public UmlElement[] getAdditionalElements() {
        return new UmlElement[]{this.operation};
    }
}

