/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.tools;

public abstract class Logger {
    private static Logger logger;

    public static Logger getLogger() {
        if (logger == null) {
            logger = Boolean.getBoolean("ch.e2e.builder.development") ? new SystemOutLogger() : new NoLogLogger();
        }
        return logger;
    }

    public abstract void log(String var1);

    private static class NoLogLogger
    extends Logger {
        private NoLogLogger() {
        }

        @Override
        public void log(String message) {
        }
    }

    private static class SystemOutLogger
    extends Logger {
        private SystemOutLogger() {
        }

        @Override
        public void log(String message) {
            System.out.println(message);
        }
    }
}

