/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.document.importer.java.Completable;
import ch.e2e.builder.compiler.document.importer.java.ElementParent;
import ch.e2e.builder.compiler.document.importer.java.TypeInfo;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeParameter;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.Helpers;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Parameter
extends BridgeParameter
implements Completable {
    private ElementParent elementParent;
    private Class<?> javaType;
    private boolean array = false;
    private int arrayDimension = 0;
    private boolean collection = false;
    private boolean map = false;

    public Parameter(String name, TypeInfo typeInfo, Direction direction, ElementParent elementParent, Helpers helpers) {
        super(name, typeInfo.getBridgeType(), direction, typeInfo.getBridgeType() != null && typeInfo.getBridgeType().equals(helpers.getElementHelper().findBaseType("Base Types/Array", null)) ? helpers.getStereotypeFactory().getStereotype("E2EArrayParameter") : helpers.getStereotypeFactory().getStereotype("E2EParameter"), helpers);
        this.elementParent = elementParent;
        this.setTypeInfo(typeInfo);
    }

    private void setTypeInfo(TypeInfo typeInfo) {
        this.javaType = typeInfo.getJavaType();
        this.array = typeInfo.isArray();
        this.arrayDimension = typeInfo.getArrayDimension();
        this.collection = typeInfo.isCollection();
        this.map = typeInfo.isMap();
        this.setTypeClass(typeInfo.getBridgeType());
        this.setNativeType(typeInfo.getNativeType());
        this.setArrayElement(typeInfo.getArrayElement(), typeInfo.getNativeArrayElement());
    }

    public Class<?> getJavaClass() {
        return this.javaType;
    }

    public boolean isPrimitive() {
        boolean result = this.javaType.isArray() ? this.javaType.getComponentType().isPrimitive() : this.javaType.isPrimitive();
        return result;
    }

    @Override
    public BridgeClass getArrayElement() {
        return (BridgeClass)this.getPropertyValueQuietly("arrayElement");
    }

    @Override
    public void setArrayElement(BridgeClass bridgeType, String javaType) {
        this.setPropertyValueQuietly("arrayElement", bridgeType);
        if (bridgeType != null) {
            this.setPropertyValueQuietly("nativeArrayElement", javaType);
        } else {
            this.setPropertyValueQuietly("nativeArrayElement", null);
        }
    }

    @Override
    public String getNativeType() {
        return (String)this.getPropertyValueQuietly("nativeType");
    }

    public void setNativeType(String javaType) {
        this.setPropertyValueQuietly("nativeType", javaType);
    }

    @Override
    public String getNativeArrayElement() {
        return (String)this.getPropertyValueQuietly("nativeArrayElement");
    }

    @Override
    public boolean isArray() {
        return this.array;
    }

    public int getArrayDimension() {
        return this.arrayDimension;
    }

    @Override
    public boolean isCollection() {
        return this.collection;
    }

    @Override
    public boolean isMap() {
        return this.map;
    }

    @Override
    public ElementParent getAttributeParent() {
        return this.elementParent;
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        return super.toXMI(ownerDocument, xmiIDFactory);
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        return super.toChildXMI(ownerDocument, xmiIDFactory);
    }
}

