/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.version;

import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.builder.compiler.build.types.tabfile.TextElement;
import ch.e2e.builder.compiler.build.types.version.File;
import ch.e2e.builder.compiler.build.types.version.FileSystem;
import ch.e2e.dom.DomUtilities;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Repository
extends RichElement {
    public static final String ELEMENT_NAME = "Repository";
    private String version;
    private FileSystem fileSystem;
    private Map<String, File> files = new LinkedHashMap<String, File>();

    public Repository() {
    }

    public Repository(Element tabfileElement) {
        super(tabfileElement);
        this.version = DomUtilities.getTextValue((Element)tabfileElement, (String)"Version", (String)"4_0");
        Iterator fileIterator = DomUtilities.elementIterator((NodeList)tabfileElement.getElementsByTagName("File"));
        while (fileIterator.hasNext()) {
            File incoming = new File((Element)fileIterator.next());
            this.files.putIfAbsent(incoming.getAttributeValue("name"), incoming);
        }
        Element fsElement = DomUtilities.getFirstElement((NodeList)tabfileElement.getElementsByTagName("FileSystem"));
        if (fsElement != null) {
            this.fileSystem = new FileSystem(fsElement);
        }
    }

    public void merge(Repository other) {
        if (other.version != null) {
            this.version = other.version;
        }
        this.files.putAll(other.files);
        if (other.fileSystem != null) {
            this.fileSystem = other.fileSystem;
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected void prepareChildren() {
        this.appendChild(new TextElement("Version", this.version));
        this.appendChildren(this.files.values());
        this.appendChild(this.fileSystem);
    }
}

