/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.rest.descriptor;

import ch.e2e.builder.compiler.build.types.addons.rest.descriptor.Tag;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.builder.compiler.build.types.tabfile.SimpleElement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class Tags
extends RichElement {
    public static final String ELEMENT_NAME = "tags";
    private Map<String, Tag> tags = new LinkedHashMap<String, Tag>();

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean hasEntries() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public Tags(Element tabfileElement) {
        super(tabfileElement);
        Iterator<Element> tagIterator = Tags.getElementIteratorByXPath(tabfileElement, "tag");
        while (tagIterator.hasNext()) {
            this.addTag(tagIterator.next());
        }
    }

    private void addTag(Element tabfileElement) {
        Tag tag = new Tag(tabfileElement);
        this.tags.putIfAbsent(tag.getName(), tag);
    }

    public void addAll(Map<String, Tag> otherTags) {
        this.tags.putAll(otherTags);
    }

    public Map<String, Tag> getTags() {
        return this.tags;
    }

    @Override
    protected void prepareChildren() {
        SimpleElement[] array = this.tags.values().toArray(new Tag[0]);
        Arrays.sort(array, new Comparator<Tag>(){

            @Override
            public int compare(Tag lhs, Tag rhs) {
                int result = lhs.getOrder().compareTo(rhs.getOrder());
                if (result == 0) {
                    result = lhs.getName().compareTo(rhs.getName());
                }
                return result;
            }
        });
        this.appendChildren(array);
    }
}

